// Enigma's Game Editor
// Copyright (C) 2001 Brian Enigma <enigma@netninja.com>
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version. 
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: space.c,v 1.2 2001/06/08 08:53:05 enigma Exp $

#define STra (UInt32)(0x53547261)

static Boolean spaceHandleEvent(EventType *event);
static Boolean spacePopulate();
static Boolean spaceSave();

Boolean spaceSeen = false;

static Boolean spaceHandleEvent(EventType *event)
{
    switch (event->eType)
    {
        case winEnterEvent:
            spacePopulate();
            return true;
        case ctlSelectEvent:
            // Cancel button
            if (event->data.ctlSelect.controlID == BtnSpaceCancel)
            {
                // Jump to main form
                FrmGotoForm(FrmMain);
                clearList(1);
                return true;
            // OK button
            } else if (event->data.ctlSelect.controlID == BtnSpaceOk) {
                // Save things
                spaceSave();
                // Jump to main form
                clearList(1);
                FrmGotoForm(FrmMain);
                return true;
            }
    }
    return false;
    
}

// Display error message if no save game
static void spaceErrorNoSaveGame()
{
    if (!spaceSeen)
    {
        spaceSeen = true;
        FrmCustomAlert(AltError,
            "Before editing, you must first save a Space Trader game.","","");
    }
}

// Populate form data in the Sim form
static Boolean spacePopulate()
{
    Boolean rc;
    rc = loadFieldFromFileByNameAndRecName(TxtSpaceMoney, TYPE_LONG, "Saved Preferences", STra, 0x02);
    if (!rc)
    {
        spaceErrorNoSaveGame();
        return;
    }
    loadFieldFromFileByNameAndRecName(TxtSpacePilot, TYPE_BYTE, "Saved Preferences", STra, 0x16F);
    loadFieldFromFileByNameAndRecName(TxtSpaceFighter, TYPE_BYTE, "Saved Preferences", STra, 0x170);
    loadFieldFromFileByNameAndRecName(TxtSpaceTrader, TYPE_BYTE, "Saved Preferences", STra, 0x171);
    loadFieldFromFileByNameAndRecName(TxtSpaceEngineer, TYPE_BYTE, "Saved Preferences", STra, 0x172);
    return true;
}

static Boolean spaceSave()
{
    saveFieldToFileByNameAndRecName(TxtSpaceMoney, TYPE_LONG, "Saved Preferences", STra, 0x02);
    saveFieldToFileByNameAndRecName(TxtSpacePilot, TYPE_BYTE, "Saved Preferences", STra, 0x16F);
    saveFieldToFileByNameAndRecName(TxtSpaceFighter, TYPE_BYTE, "Saved Preferences", STra, 0x170);
    saveFieldToFileByNameAndRecName(TxtSpaceTrader, TYPE_BYTE, "Saved Preferences", STra, 0x171);
    saveFieldToFileByNameAndRecName(TxtSpaceEngineer, TYPE_BYTE, "Saved Preferences", STra, 0x172);
    return true;
}

