// Enigma's Game Editor
// Copyright (C) 2001 Brian Enigma <enigma@netninja.com>
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version. 
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: solskia.c,v 1.2 2001/06/26 08:51:26 enigma Exp $

static Boolean solskiaHandleEvent(EventType *event);
static Boolean solskiaPopulate();
static Boolean solskiaSave();

Boolean solskiaSeen = false;

static Boolean solskiaHandleEvent(EventType *event)
{
    switch (event->eType)
    {
        case winEnterEvent:
            solskiaPopulate();
            return true;
        case ctlSelectEvent:
            // Cancel button
            if (event->data.ctlSelect.controlID == BtnSolskiaCancel)
            {
                // Jump to main form
                FrmGotoForm(FrmMain);
                return true;
            // OK button
            } else if (event->data.ctlSelect.controlID == BtnSolskiaOk) {
                // Save things
                solskiaSave();
                // Jump to main form
                FrmGotoForm(FrmMain);
                return true;
            }
    }
    return false;
}

// Display error message if no save games
static void solskiaErrorNoSaveGame()
{
    if (!solskiaSeen)
    {
        solskiaSeen = true;
        FrmCustomAlert(AltError,
            "Before editing, you must first save a Kyle's Quest game.","","");
    }
}



static Boolean solskiaPopulate(int record)
{
    if (
    loadFieldFromFileByName(TxtSolskiaMoney,   TYPE_INT, "s_a_char.sav", 0, 
        0x35)
        == false)
    {
        solskiaErrorNoSaveGame();
        return true;
    }
    loadFieldFromFileByName(TxtSolskiaHealth1, TYPE_INT12, "s_a_char.sav", 0, 
        0x12);
    loadFieldFromFileByName(TxtSolskiaHealth2, TYPE_INT12, "s_a_char.sav", 0, 
        0x2D);
    loadFieldFromFileByName(TxtSolskiaExp,     TYPE_INT, "s_a_char.sav", 0, 
        0x39);
    return true;
}

static Boolean solskiaSave()
{
    saveFieldToFileByName(TxtSolskiaMoney,   TYPE_INT, "s_a_char.sav", 0, 
        0x35);
    saveFieldToFileByName(TxtSolskiaHealth1, TYPE_INT12, "s_a_char.sav", 0, 
        0x12);
    saveFieldToFileByName(TxtSolskiaHealth2, TYPE_INT12, "s_a_char.sav", 0, 
        0x2D);
    saveFieldToFileByName(TxtSolskiaExp,     TYPE_INT, "s_a_char.sav", 0, 
        0x39);
    return true;
}

