// Enigma's Game Editor
// Copyright (C) 2001 Brian Enigma <enigma@netninja.com>
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version. 
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: realms.c,v 1.1 2001/06/08 08:53:05 enigma Exp $

static Boolean realmsHandleEvent(EventType *event);
static Boolean realmsPopulate();
static Boolean realmsSave();

Boolean realmsSeen = false;

static Boolean realmsHandleEvent(EventType *event)
{
    switch (event->eType)
    {
        case winEnterEvent:
            realmsPopulate();
            return true;
        case ctlSelectEvent:
            // Cancel button
            if (event->data.ctlSelect.controlID == BtnRealmsCancel)
            {
                // Jump to main form
                FrmGotoForm(FrmMain);
                clearList(1);
                return true;
            // OK button
            } else if (event->data.ctlSelect.controlID == BtnRealmsOk) {
                // Save things
                realmsSave();
                // Jump to main form
                clearList(1);
                FrmGotoForm(FrmMain);
                return true;
            }
    }
    return false;
    
}

// Display error message if no save game
static void realmsErrorNoSaveGame()
{
    if (!realmsSeen)
    {
        realmsSeen = true;
        FrmCustomAlert(AltError,
           "Before editing, you must first save a Galactic Realms game.","","");
    }
}

// Populate form data in the Sim form
static Boolean realmsPopulate()
{
    Boolean rc;
    rc = loadFieldFromFileByName(TxtRealmsMoney, TYPE_INT, "GR Continue", 0, 0x3da6);
    if (!rc)
    {
        realmsErrorNoSaveGame();
        return;
    }
    loadFieldFromFileByName(TxtRealmsAttack, TYPE_BYTE, "GR Continue", 0, 0x3db1);
    loadFieldFromFileByName(TxtRealmsDefence, TYPE_BYTE, "GR Continue", 0, 0x3db2);
    return true;
}

static Boolean realmsSave()
{
    saveFieldToFileByName(TxtRealmsMoney, TYPE_INT, "GR Continue", 0, 0x3da6);
    saveFieldToFileByName(TxtRealmsAttack, TYPE_BYTE, "GR Continue", 0, 0x3db1);
    saveFieldToFileByName(TxtRealmsDefence, TYPE_BYTE, "GR Continue", 0, 0x3db2);
    return true;
}

