// Enigma's Game Editor
// Copyright (C) 2001 Brian Enigma <enigma@netninja.com>
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version. 
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: main.c,v 1.12 2001/10/21 22:58:46 enigma Exp $

#include <PalmOS.h>
#include "resource.h"
#include "general.c"

static Boolean mainHandleEvent(EventType *event);
static void clearList(int dispose);
char *list[10];
LocalID listIds[10];
#define QUEST_TYPE 0x44617461
                                    // "Data"
#define QUEST_CREATOR 0x51737431
                                    // "Qst1"

#include "simcity.c"
#include "quest.c"
#include "knight.c"
#include "space.c"
#include "realms.c"
#include "solskia.c"
#include "bebop.c"

static void clearList(int dispose)
{
    int i;
    //SndPlaySystemSound(sndError);
    for (i=0; i<10; i++)
    {
        if (dispose && list[i])
            MemPtrFree(list[i]);
        list[i] = 0;
        listIds[i] = 0;
    }
}

UInt32 PilotMain(UInt16 cmd, void *junk1, UInt16 junk2)
{
    UInt16 error;
    FormPtr form;
    //FormPtr oldForm;
    EventType event;
    UInt32 romVersion;

    // Don't launch if this wasn't the right launch code
    if (cmd != sysAppLaunchCmdNormalLaunch)
        return 0;

    clearList(0);
    form = FrmInitForm(FrmMain);
    FrmSetEventHandler(form, mainHandleEvent);
    FrmSetActiveForm(form);
    FrmDrawForm(form);

    do
    {
        EvtGetEvent(&event, evtWaitForever);
        if (SysHandleEvent(&event))
            continue;
        if (MenuHandleEvent(NULL, &event, &error))
            continue;
        if (FrmDispatchEvent(&event))
            continue;
        //if (ApplicationHandleEvent(&event))
        //        continue;

        if (event.eType == menuEvent) {
            FrmAlert(AltAbout);
            continue;
        }
        FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
    FrmEraseForm(form);
    FrmDeleteForm(form);
    clearList(1);
    return 0;
}

static Boolean mainHandleEvent(EventType *event)
{
    FormPtr previousForm;
    FormPtr newForm;
    static selection = 0;
    switch (event->eType)
    {
        // "About..." selected
        case menuEvent:
            previousForm = FrmGetActiveForm();
            newForm = FrmInitForm(FrmAbout);
            FrmSetActiveForm(newForm);
            FrmDoDialog(newForm);
            FrmSetActiveForm(previousForm);
            FrmEraseForm(newForm);
            FrmDeleteForm(newForm);
            return true;
        // New item selected in the list
        case lstSelectEvent:
            selection = event->data.lstSelect.selection;
            return true;
        // Go button pressed
        case ctlSelectEvent:
            switch(event->data.ctlSelect.controlID)
            {
                case BtnVersion:
                    // Display "About..." box
                    previousForm = FrmGetActiveForm();
                    newForm = FrmInitForm(FrmAbout);
                    FrmSetActiveForm(newForm);
                    FrmDoDialog(newForm);
                    FrmSetActiveForm(previousForm);
                    FrmEraseForm(newForm);
                    FrmDeleteForm(newForm);
                    return true;
                case BtnGo:
                    // Go to proper form
                    previousForm = FrmGetActiveForm();
                    switch(selection)
                    {
                        case 0:
                            newForm = FrmInitForm(FrmSim);
                            FrmSetActiveForm(newForm);
                            FrmSetEventHandler(newForm, simHandleEvent);
                            FrmDoDialog(newForm);
                            clearList(1);
                            FrmSetActiveForm(previousForm);
                            FrmEraseForm(newForm);
                            FrmDeleteForm(newForm);
                            break;
                        case 1:
                            newForm = FrmInitForm(FrmQuest);
                            FrmSetActiveForm(newForm);
                            FrmSetEventHandler(newForm, questHandleEvent);
                            FrmDoDialog(newForm);
                            clearList(1);
                            FrmSetActiveForm(previousForm);
                            FrmEraseForm(newForm);
                            FrmDeleteForm(newForm);
                            break;
                        case 2:
                            newForm = FrmInitForm(FrmKnight);
                            FrmSetActiveForm(newForm);
                            FrmSetEventHandler(newForm, knightHandleEvent);
                            FrmDoDialog(newForm);
                            clearList(1);
                            FrmSetActiveForm(previousForm);
                            FrmEraseForm(newForm);
                            FrmDeleteForm(newForm);
                            break;
                        case 3:
                            newForm = FrmInitForm(FrmSpace);
                            FrmSetActiveForm(newForm);
                            FrmSetEventHandler(newForm, spaceHandleEvent);
                            FrmDoDialog(newForm);
                            clearList(1);
                            FrmSetActiveForm(previousForm);
                            FrmEraseForm(newForm);
                            FrmDeleteForm(newForm);
                            break;
                        case 4:
                            newForm = FrmInitForm(FrmRealms);
                            FrmSetActiveForm(newForm);
                            FrmSetEventHandler(newForm, realmsHandleEvent);
                            FrmDoDialog(newForm);
                            clearList(1);
                            FrmSetActiveForm(previousForm);
                            FrmEraseForm(newForm);
                            FrmDeleteForm(newForm);
                            break;
                        case 5:
                            newForm = FrmInitForm(FrmSolskia);
                            FrmSetActiveForm(newForm);
                            FrmSetEventHandler(newForm, solskiaHandleEvent);
                            FrmDoDialog(newForm);
                            clearList(1);
                            FrmSetActiveForm(previousForm);
                            FrmEraseForm(newForm);
                            FrmDeleteForm(newForm);
                            break;
                        case 6:
                            newForm = FrmInitForm(FrmBebop);
                            FrmSetActiveForm(newForm);
                            FrmSetEventHandler(newForm, bebopHandleEvent);
                            FrmDoDialog(newForm);
                            clearList(1);
                            FrmSetActiveForm(previousForm);
                            FrmEraseForm(newForm);
                            FrmDeleteForm(newForm);
                            break;
                        default:
                            SndPlaySystemSound(sndError);
                            break;
                    }// switch selection
                    return true;
                }//switch controlId
    }//switch event type
    return false;
}

