// Enigma's Game Editor
// Copyright (C) 2001 Brian Enigma <enigma@netninja.com>
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version. 
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: knight.c,v 1.4 2001/06/08 08:53:05 enigma Exp $

#define KNMV (UInt32)(0x4b4e4d56)

static Boolean knightHandleEvent(EventType *event);
static Boolean knightPopulate();
static Boolean knightSave();

Boolean knightSeen = false;

static Boolean knightHandleEvent(EventType *event)
{
    switch (event->eType)
    {
        case winEnterEvent:
            knightPopulate();
            return true;
        case ctlSelectEvent:
            // Cancel button
            if (event->data.ctlSelect.controlID == BtnKnightCancel)
            {
                // Jump to main form
                FrmGotoForm(FrmMain);
                clearList(1);
                return true;
            // OK button
            } else if (event->data.ctlSelect.controlID == BtnKnightOk) {
                // Save things
                knightSave();
                // Jump to main form
                clearList(1);
                FrmGotoForm(FrmMain);
                return true;
            }
    }
    return false;
    
}

// Display error message if no save game
static void knightErrorNoSaveGame()
{
    if (!knightSeen)
    {
        knightSeen = true;
        FrmCustomAlert(AltError,
            "Before editing, you must first save a Knight Move game.","","");
    }
}

// Populate form data in the Sim form
static Boolean knightPopulate()
{
    Boolean rc;
    rc = loadFieldFromFileByNameAndRecName(TxtKnight1, TYPE_LONG, "Unsaved Preferences", KNMV, 0x6a);
    if (rc==false)
    {
        knightErrorNoSaveGame();
        return;
    }
    loadFieldFromFileByNameAndRecName(TxtKnight2, TYPE_LONG, "Unsaved Preferences", KNMV, 0x29a);
    loadFieldFromFileByNameAndRecName(TxtKnight3, TYPE_LONG, "Unsaved Preferences", KNMV, 0x4ca);
    loadFieldFromFileByNameAndRecName(TxtKnight4, TYPE_LONG, "Unsaved Preferences", KNMV, 0x6fa);
    return true;
}

static Boolean knightSave()
{
    saveFieldToFileByNameAndRecName(TxtKnight1, TYPE_LONG, "Unsaved Preferences", KNMV, 0x6a);
    saveFieldToFileByNameAndRecName(TxtKnight2, TYPE_LONG, "Unsaved Preferences", KNMV, 0x29a);
    saveFieldToFileByNameAndRecName(TxtKnight3, TYPE_LONG, "Unsaved Preferences", KNMV, 0x4ca);
    saveFieldToFileByNameAndRecName(TxtKnight4, TYPE_LONG, "Unsaved Preferences", KNMV, 0x6fa);
    return true;
}
