// Enigma's Game Editor
// Copyright (C) 2001 Brian Enigma <enigma@netninja.com>
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version. 
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details. 
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// $Id: bebop.c,v 1.2 2001/10/21 23:38:46 enigma Exp $

static Boolean bebopHandleEvent(EventType *event);
static Boolean bebopPopulate();
static Boolean bebopSave();

Boolean bebopSeen = false;

static Boolean bebopHandleEvent(EventType *event)
{
    switch (event->eType)
    {
        case winEnterEvent:
            bebopPopulate();
            return true;
        case ctlSelectEvent:
            // Cancel button
            if (event->data.ctlSelect.controlID == BtnBebopCancel)
            {
                // Jump to main form
                FrmGotoForm(FrmMain);
                clearList(1);
                return true;
            // OK button
            } else if (event->data.ctlSelect.controlID == BtnBebopOk) {
                // Save things
                bebopSave();
                // Jump to main form
                clearList(1);
                FrmGotoForm(FrmMain);
                return true;
            }
    }
    return false;
    
}

// Display error message if no save game
static void bebopErrorNoSaveGame()
{
    if (!bebopSeen)
    {
        bebopSeen = true;
        FrmCustomAlert(AltError,
           "Before editing, you must first save a BeBop game.","","");
    }
}

// Populate form data in the Sim form
static Boolean bebopPopulate()
{
    Boolean rc;
    rc = loadFieldFromFileByName(TxtBebopMoney, TYPE_LONG, "BeBopSave", 0, 0x20);
    if (!rc)
    {
        bebopErrorNoSaveGame();
        return;
    }
    return true;
}

static Boolean bebopSave()
{
    saveFieldToFileByName(TxtBebopMoney, TYPE_LONG, "BeBopSave", 0, 0x20);
    return true;
}

