/*
                     Pilot GO show board routines
                Version 0.22 last revised 9-17-97

               adapted for the USR Pilot & PalmPilot
                  9/10/97 by Matthias von Davier
*/

/*
                 GNUGO - the game of Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

           manli@cs.uh.edu

*/

/* SEND MODIFICATIONS of the PILOT version to:
 *
 *         vdavier@ipn.uni-kiel.de
 *
 *
 * Pilot Go
 *
 * by Matthias von Davier
 * september 1997
 */

#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "pigoID.h"
#include "pigoTY.h"

#define PilotGoAppID    'PiGO'   // 0x74586858 in hexadecimal
#define PilotGoDBType   'Data'   // 0x64415441 in hexadecimal

#include "extvargo.h"


int rand(void)
{   return SysRandom(0);
    }

void Newgame(void)
  { int i;
    int j;

   for (i=0;i<game.BoardSize+1; i++)
    {
     for(j=0;j<game.BoardSize+1; j++)
     {
      game.p[i][j] = EMPTY;
     }
    }

/* init global variables */
    game.mk = 0;  game.uk = 0;
    game.handicap = 0;
/* init global variables */
    game.play = PLAY;
    game.pass = 0;
    game.mik = -1; game.mjk = -1;
    game.uik = -1; game.ujk = -1;
    game.lastX = -1; game.lastY = -1;
  }

void ClearScreen(void)
  {
    RectangleType r;
    Word Diam=0;
    r.topLeft.x = 0;
    r.topLeft.y = 0;
    r.extent.x  = 160;
    r.extent.y  = 160;
    WinEraseRectangle(&r,Diam);
    }

void DrawMarker(int x,int y, unsigned char color)
{
    RectangleType r;

    r.topLeft.x = x*width + offset - 1;
    r.topLeft.y = y*width + offset - 1;
    r.extent.x  = 3;
    r.extent.y  = r.extent.x;
    if (color==BLACK)
      WinDrawRectangle(&r,0);
    else
      WinEraseRectangle(&r,0);

    }

void DrawOnBoard(int x, int y,
                 unsigned char color,
                 Word Size, Word Diam)
  {
    int x1,x2,y1,y2;
    RectangleType r;

    r.topLeft.x = x*width + offset - Size;
    r.topLeft.y = y*width + offset - Size;
    r.extent.x  = 2 * Size + 1;
    r.extent.y  = r.extent.x;

    WinEraseRectangle(&r,0);

    switch (color)
    {
    case BLACK:
       WinDrawRectangle(&r,Diam);
       break;
    case WHITE:
      WinDrawRectangle(&r,Diam);
      r.topLeft.x ++;
      r.topLeft.y ++;
      r.extent.x -= 2;
      r.extent.y -= 2;
      WinEraseRectangle(&r,Diam-1);
      break;
    case EMPTY:
      x1 = x*width + offset - Size - 1;
      x2 = MIN(160-offset,x1 + 2*Size + 2);
      x1 = MAX(offset,x1);
      y1 = y*width + offset;
      WinDrawLine(x1,y1,x2,y1);
      if (x != 0) x1 += (Size + 1);
      y1 -= (Size + 1);
      y2 = MIN(160-offset,y1 + 2*Size+2);
      y1 = MAX(offset,y1);
      WinDrawLine(x1,y1,x1,y2);
      break;
    case HINT:
      WinDrawRectangle(&r,0);
      switch (game.BoardSize)
      {
      case 19:
        x1 = 1;
        y1 = -1;
        break;
      case 13:
        x1 = 3;
        y1 = 0;
        break;
      case  9:
        x1 = 6;
        y1 = 3;
        break;
      }
      x1 += r.topLeft.x;
      y1 += r.topLeft.y;
      WinDrawInvertedChars("H",1,x1,y1);
      break;
    }

  }

void DrawMarkers(void)
{
   int start, end, step, i, j;

   /* draw markers for better orientation */
   switch (game.BoardSize)
   {
    case 9:
      start =  2;
      end   =  6;
      step  =  2;
      break;
    case 13:
      start =  3;
      end   =  9;
      step  =  3;
      break;
    case 19:
      start =  3;
      end   = 15;
      step  =  6;
      break;
   }
   for (i=start;i<=end;i+=step)
   {
    for (j=start;j<=end;j+=step)
    {
     if (game.p[i][j] == EMPTY) DrawMarker(i,j,BLACK);
    }
   }
}

void DrawPiece(int x, int y, unsigned char color, Boolean last)
 {
    /* RectangleType r; */

    Word Diam = (width / 2) - 1;
    DrawOnBoard(x,y,color,Diam,Diam);
    switch (color)
    {
      case EMPTY:
        DrawMarkers();
        break;
      case WHITE:
        if (last) DrawMarker(x,y,BLACK);
        break;
      case BLACK:
        if (last) DrawMarker(x,y,WHITE);
        break;
    }
 }

void DrawBoard(void)
 {
   int i,j,start,end,step;
   int x1,x2,y1,y2;

   offset = 7; // - game.BoardSize / 10;

   width = (160-2*offset)/(game.BoardSize-1);

   /* recompute due to integer arithmetics */
   offset = (160 - width*(game.BoardSize - 1)) / 2;

   y1=offset;
   y2=160-offset;

   // ClearScreen();

   for (i = 0; i < game.BoardSize; i++)
   {
     x1 = offset + i*width;
     /* x2 = x1; */
     WinDrawLine(x1,y1,x1,y2);
   }

   x1 = offset;
   x2 = 160 - offset;

   for (i = 0; i < game.BoardSize; i++)
   {
     y1 = offset + i*width;
     /* y2 = y1; */
     WinDrawLine(x1,y1,x2,y1);
   }
   DrawMarkers();
 }

void ShowBoard(void)
 {
   int i,j;

   ClearScreen();
   DrawBoard();

   for (i=0;i<game.BoardSize; i++)
   {
    for(j=0;j<game.BoardSize; j++)
    {
     if (game.p[i][j] != EMPTY) DrawPiece(i,j,game.p[i][j],FALSE);
    }
   }
 }

