/*
                     Pilot GO frame program
                Version 0.22 last revised 9-17-97

               adapted for the USR Pilot & PalmPilot
                  9/10/97 by Matthias von Davier
*/

/*

                 GNUGO - the game of Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

           manli@cs.uh.edu

*/

/* SEND MODIFICATIONS of the PILOT version to:
 *
 *         vdavier@ipn.uni-kiel.de
 *
 *
 * Pilot Go
 *
 * by Matthias von Davier
 * september 1997
 */


#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "pigoID.h"
#include "pigoTY.h"


#define PilotGoAppID    'PiGO'   // 0x74586858 in hexadecimal
#define PilotGoDBType   'Data'   // 0x64415441 in hexadecimal

unsigned char p[19][19];  /* go board */
unsigned char l[19][19];  /* liberty of current color */
unsigned char ma[19][19]; /* working matrix for marking */
unsigned char ml[19][19]; /* working matrix for marking */
// int mymove=BLACK, umove=WHITE; /* computer color, opponent color */
int lib;                  /* current stone liberty */
// int play;                 /* game state */
// int pass = 0;             /* pass indicator */
int mik, mjk;             /* location of computer stone captured */
int uik, ujk;             /* location of opponent stone captured */
int mk, uk;               /* no. of stones captured by computer and oppoent */
int opn[9];               /* opening pattern flag */
long int mtot,utot;
int i,j;

int BoardSize =  19;
int offset, width;
int handicap = 0;
Word FrmRet;
GAME game;

char EndMess1[60] = "";
char EndMess2[40] = "\n My score:   ";
char EndMess3[40] = "\n Your score: ";
char SMytot[5] = "00000";
char SUtot[5]  = "00000";

int penX, penY, dummy;
int moved;

static DmOpenRef pgDB;

static int StartApplication(void);
static Err OpenDatabase(void);
static void SaveStatus(void);
static void EventLoop(void);
static void StopApplication(void);
static Boolean PilotGo(EventPtr event);
static void KnightMoves(void);


FieldPtr	fieldptr_text;   // FieldPtr and DmOpenRef are defined in the PalmOS header files.
FieldPtr	fieldptr_hex;    // See if you can find where they are defined.
DmOpenRef   PilotGoDB;

char            PilotGoDBName[] = "PilotGoDB";
char            hex[60];
int             WhichBitmap;


void Swap(int *i, int *j)
 {
  int temp;
  temp = *i;
  *i = *j;
  *j = temp;
 }

void StoneHenge(int penX, int penY, int MoveColor, int OtherColor)
{

    if (game.lastX != -1) DrawPiece(game.lastX,game.lastY,game.p[game.lastX][game.lastY],FALSE);
    if (MoveColor != HINT)
    {
     game.p[penX][penY] = MoveColor;
     examboard(OtherColor);
    }
    DrawPiece(penX,penY,MoveColor,TRUE);
    game.lastX = penX;
    game.lastY = penY;
  }

Boolean HumanMove(int penX, int penY)
{
  if ((game.p[penX][penY] != EMPTY) || suicide(penX, penY))
  {
    FrmCustomAlert(alertID_message,"","Illegal move!","");
    return FALSE;
  }
  else
  {
    StoneHenge(penX,penY,game.umove,game.mymove);
    game.pass = 0;
    return TRUE;
  }
}


static void KnightMoves(void)
 {
  int penX,penY;

  genmove(&penX,&penY);
  if (penX != -1)
    StoneHenge(penX,penY,game.mymove,game.umove);
  else
    FrmCustomAlert(alertID_message,"","I pass!","");
 }

DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
  int error;

  if (cmd == sysAppLaunchCmdNormalLaunch)
 {

    error = StartApplication();	// Application start code
    if (error) return error;

    EventLoop();	// Event loop

    StopApplication ();	// Application stop code
  }
  return 0;
}



static int StartApplication(void)
{
  int error;

  error = OpenDatabase();
  if (error) return error;
  FrmGotoForm(formID_PilotGo);
}

static void EventLoop(void)
{
  short err;
  int formID;
  FormPtr form;
  EventType event;

  do
  {

    EvtGetEvent(&event, 200);

    if (SysHandleEvent(&event)) continue;
    if (MenuHandleEvent((void *)0, &event, &err)) continue;

    if (event.eType == frmLoadEvent)
    {
      formID = event.data.frmLoad.formID;
      form = FrmInitForm(formID);
      FrmSetActiveForm(form);
      switch (formID) 
      {
      case formID_PilotGo:
        FrmSetEventHandler(form, (FormEventHandlerPtr) PilotGo);
        break;
      }
    }
    FrmDispatchEvent(&event);
  } while(event.eType != appStopEvent);
}

static void StopApplication(void)
{
  FrmCloseAllForms();
  SaveStatus();
  DmCloseDatabase(pgDB);
}

static Boolean PilotGo(EventPtr event)
{
  FormPtr   form;
  int       handled = 0;

  switch (event->eType)
  {
  case frmOpenEvent:
    form = FrmGetActiveForm();
    FrmDrawForm(form);

    ClearScreen();
    ShowBoard();

    handled = 1;
    break;
  case penDownEvent:
    dummy = (width / 2) - offset;
    penX = (event->screenX + dummy) / width;
    penX = MIN(18,MAX(0,penX));
    penY = (event->screenY + dummy) / width;
    penY = MIN(18,MAX(0,penY));
    switch (game.play)
    {
    case PLAY:
      if (HumanMove(penX,penY)) KnightMoves();
      break;
    case ENDGAME:

    case FILLNEUTRAL:
       if (game.p[penX][penY] == EMPTY)
       {
        game.p[penX][penY] = game.fill;
        DrawPiece(penX,penY,game.fill,FALSE);
        if (game.fill == BLACK)
         game.fill = WHITE;
        else
         game.fill = BLACK;
       }
       else
       {
        FrmCustomAlert(alertID_message,"","This intersection is not empty!","");
       }
     break;
    case REMOVEDEAD:
      game.p[penX][penY] = EMPTY;
      DrawPiece(penX,penY,EMPTY,FALSE);
      // RemoveDead(penX,penY);

      // goto LABELNewGame;
      break;
    case HANDICAP:
      HumanMove(penX,penY);
      break;
    }
  case menuEvent:
    switch (event->data.menu.itemID)
    {
    case 0:
      break;
    case menuitemID_hint:
      Swap(&game.mymove,&game.umove);
      genmove(&penX,&penY);
      StoneHenge(penX,penY,HINT,0);
      Swap(&game.mymove,&game.umove);
      break;
    case menuitemID_help:
      // FrmAlert(alertID_showinst);
      FrmHelp(HelpStr);
      break;
    case menuitemID_pass:
      if(game.play==PLAY)
      { /* FrmAlert(alertID_about); */
        if (FrmCustomAlert(alertID_confirm,"","Pass move?","") == 0)
        {
          ++game.pass;
          if (game.pass<2) KnightMoves();
        }
      }
      break;
    case menuitemID_about:
      FrmAlert(alertID_about);
      break;

    case menuitemID_choose:

/* choose color */
      if (FrmAlert(alertID_choose) == 0)
       {
         game.mymove = 1;   /* computer white */
         game.umove = 2;    /* human black */
       }
      else
       {
         game.mymove = 2;   /* computer black */
         game.umove = 1;    /* human white */
       }
      goto LABELNewGame;
      break;
    case menuitemID_newgame:

LABELNewGame:
      if (FrmCustomAlert(alertID_confirm,"Start new game?","","") == 0)
      {
        Newgame();
        SaveStatus();
        ShowBoard();
      }
      break;
    case menuitemID_loadgame:
      goto LABELNotYet;
      /* FrmCustomoAlert(alertID_message,"","Not Yet implemented",""); */
      break;
    case menuitemID_savegame:
LABELNotYet:
      FrmCustomAlert(alertID_message,"","Not Yet implemented","");
      /* if (FrmCustomAlert(alertID_confirm,"Save Game? ","Save game status?","") == 0)
      { SaveStatus(); } */
      break;
    case menuitemID_continue:
      switch (game.play)
      {
       case ENDGAME:
        // endgame();
        break;
       case REMOVEDEAD:
/* fill in neutral */

LABELFillNeutral:

         if(FrmCustomAlert(alertID_confirm,
        "Next, you need to fill in pieces (black and white) in all neutral territories. Tap on the intersections ",
        "and your and my color will be filled in alternately, choose 'Continue' when finished.",
        "\n\n Are the neutral areas?")==0)
        {
          game.play = FILLNEUTRAL;
          game.fill = BLACK;
          break;
         }
         goto LABELEndGame;
         /* do not : break; go on */
       case FILLNEUTRAL:

LABELEndGame:

/* set empty to side they belong to */
        for (i = 0; i < game.BoardSize; i++)
         for (j = 0; j < game.BoardSize; j++)
          if (game.p[i][j] == EMPTY)
           {
             game.p[i][j] = findcolor(i, j);
             DrawPiece(i,j,game.p[i][j],FALSE);
           }
/* count total */
        mtot = 0;
        utot = 0;

        for (i = 0; i < game.BoardSize; i++)
          for (j = 0; j < game.BoardSize; j++)
            if (game.p[i][j] == game.mymove)
              ++mtot;
            else
              if (game.p[i][j] == game.umove)
              ++utot;


        if (utot>mtot)
         StrCopy(EndMess1,"Can't believe it, you win!");
        else
         StrCopy(EndMess1,"I win! (pretty easy)");


        StrCopy(EndMess2,"\n My score  : ");
        StrCopy(EndMess3,"\n Your score: ");
        StrIToA(SMytot,mtot);
        StrIToA(SUtot,utot);
        FrmCustomAlert(alertID_message,EndMess1,
          StrCat(EndMess2, SMytot),
          StrCat(EndMess3, SUtot));

        goto LABELNewGame;
        break;
       case HANDICAP:
        Swap(&game.mymove,&game.umove);
        game.play = PLAY;
        break;
      }
      break;
    case menuitemID_handicap:
      if (FrmCustomAlert(alertID_confirm,"Place handicap stones now? \n\n",
                     "Place pieces manually! Use Select Color before, ",
                     "afterwards use Continue and/or Pass Move from the Options menu!") == 0)
      {
        game.play = HANDICAP;
        Swap(&game.mymove,&game.umove);
      }
      break;
    case menuitemID_setsize:
      FrmRet = FrmAlert(alertID_setsize);
      switch (FrmRet)
      {
        case 0 : BoardSize = 9;
        break;
        case 1 : BoardSize = 13;
        break;
        case 2 : BoardSize = 19;
        break;
      }
      if (BoardSize != game.BoardSize)
      {
       game.BoardSize = BoardSize;
       Newgame();
       SaveStatus();
       ShowBoard();
      }
      break;
    }
    handled = 1;
    break;
  case nilEvent:
    handled = 1;
    break;
  }

/* ENDGAME == TRUE */
    if ((game.pass > 1) && (game.play == PLAY))
    {
      // game.play = REMOVEDEAD;
      FrmCustomAlert(alertID_message,
      "To count score, we need the following steps: First, I need you to remove all ",
      "dead pieces on the board. Second, I need you to fill in neutral territories ",
      "with pieces. Last, I will fill in all pieces and announce the winner.");

/* remove dead pieces */

       game.pass = 0;

      if (FrmCustomAlert(alertID_confirm,
      "First, you should enter the dead pieces (black and white) to be removed. ",
      "Choose 'Continue' in the Options menu when finished.\n\n",
      "Are there dead pieces?")==0)
      {
        game.play = REMOVEDEAD;
      }
       else
      {
       game.play = FILLNEUTRAL;
       goto LABELFillNeutral;
      }

    }

  return handled;
}

/*
 * Database (here: game status information) handling routines.
 */

static Err OpenDatabase(void)
{
  UInt          index = 0;
  VoidHand      RecHandle;
  VoidPtr       RecPointer;
  Err           err;

  // Create database, if it doesn't exist, and save default game status.
  if (!(pgDB = DmOpenDatabaseByTypeCreator(PilotGoDBType, PilotGoAppID, dmModeReadWrite)))
  {
    if ((err = DmCreateDatabase(0, "PilotGoDB", PilotGoAppID, PilotGoDBType, false)))
      return err;
    pgDB = DmOpenDatabaseByTypeCreator(PilotGoDBType, PilotGoAppID, dmModeReadWrite);

    /* init game.structure with defaults */
    game.BoardSize = 19;
    game.umove     = BLACK;
    game.mymove    = WHITE;
    Newgame();
    // game.play      = PLAY;
    // game.pass      = 0;

    RecHandle = DmNewRecord(pgDB, &index, sizeof(game));
    DmWrite(MemHandleLock(RecHandle), 0, &game, sizeof(game));
    MemHandleUnlock(RecHandle);
    DmReleaseRecord(pgDB, index, true);
  }

  // Load a saved game status.
  RecHandle = DmGetRecord(pgDB, 0);
  RecPointer = MemHandleLock(RecHandle);
  MemMove(&game, RecPointer, sizeof(game));
  MemHandleUnlock(RecHandle);
  DmReleaseRecord(pgDB, 0, true);

  return 0;
}

/*
 * Save game status information.
 */
static void SaveStatus(void)
{
  VoidPtr p = MemHandleLock(DmGetRecord(pgDB, 0));
  DmWrite(p, 0, &game, sizeof(game));
  MemPtrUnlock(p);
  DmReleaseRecord(pgDB, 0, true);
}

