/*------------------------------
  pigoTY.h -- Pilot GO common header file
------------------------------*/

/* definitions */

#define EMPTY 0
#define WHITE 1
#define BLACK 2
#define HINT  3

#define ENDGAME     0
#define PLAY        1
#define HANDICAP    2
#define REMOVEDEAD  3
#define FILLNEUTRAL 4

#define TRUE  1
#define FALSE 0

// #define InArray(x,y)    (((x)>=0 && (x)<WIDTH) && ((y)>=0 && (y)<HEIGHT))
// #define IsVisible(x,y)  ((game.minefield[x][y] & COVERED) ? 0 : 1)
#define MAX(x,y)        ((x>y) ? x : y)
#define MIN(x,y)        ((x>y) ? y : x)

/* public types */

typedef struct {unsigned char p[19][19];
                unsigned char l[19][19];
                int mymove,umove;
                int lib;
                int play;
                int pass;
                int mk,uk;
                int opn[9];
                int mik, mjk;
                int uik, ujk;
                int BoardSize, offset, width, handicap;
                int lastX,lastY;
                int fill;
                } GAME;

/* public functions */

extern void Newgame(void);

extern void ClearScreen(void);

extern void DrawPiece(int x,
                      int y,
                      unsigned char color, Boolean last);

extern void count(int i,
                  int j,
                  int color);

extern void countlib(int m,
                     int n,
                     int color);

extern void endgame(void);

extern void eval(int color);

extern void examboard(int color);

extern int getij(char move[],
                 int *i,
                 int *j);

extern unsigned int findcolor(int i,
                              int j);

extern int findnextmove(int m,
                        int n,
                        int *i,
                        int *j,
                        int *val,
                        int minlib);

extern int findopen(int m,
                    int n,
                    int i[],
                    int j[],
                    int color,
                    int minlib,
                    int *ct);

extern int findpatn(int *i,
                    int *j,
                    int *val);

extern int findsaver(int *i,
                     int *j,
                     int *val);

extern int findwinner(int *i,
                      int *j,
                      int *val);

extern int fioe(int i,
                int j);

extern void genmove(int *i,
                    int *j);

extern void getmove(char move[],
                    int *i,
                    int *j);

extern void initmark(void);

extern int matchpat(int m,
                    int n,
                    int *i,
                    int *j,
                    int *val);

extern int opening(int *i,
                   int *j,
                   int *cnd,
                   int type);

extern int openregion(int i1,
                      int j1,
                      int i2,
                      int j2);

extern void showboard(void);

extern void showinst(void);

extern void sethand(int i);

extern int suicide(int i,
                   int j);
