/*
                 GNUGO - the game of Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber

                adapted for the USR Pilot & PalmPilot
                9/10/97 by Matthias von Davier

             ( this file does not contain GNUGO funcs
               main, getmove and getij
               as they are not used in the Pilot Version )

*/
/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

           manli@cs.uh.edu

and for the PILOT version:

           vdavier@ipn.uni-kiel.de

/* replace
 * 16 = (game.BoardSize - 3)
 * 17 = (game.BoardSize - 2)
 * 18 = (game.BoardSize - 1)
 * 19 = game.BoardSize
 * mymove = game.mymove DONE
 * umove  = game.umove DONE
 * mk = game.mk DONE
 * uk = game.uk DONE
 * p[ = game.p[ DONE
 * l[ = game.l[ DONE
 * opn[ = game.opn[ DONE
 */


/* hugo3.c Show Go Board on Pilot screen
 * 10.9.1997 MvD
 *
*/

#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "pigoID.h"
#include "pigoTY.h"

#include "patterns.h"

#define PilotGoAppID    'PiGO'   // 0x74586858 in hexadecimal
#define PilotGoDBType   'Data'   // 0x64415441 in hexadecimal

#include "extvargo.h"

/* int rand(void)
{   return SysRandom(0);
    } */

/*-------------------------------------
  count.c -- Count liberty around stone
-------------------------------------*/

void count(int i,     /* row number 0 to 18 */
           int j,     /* column number 0 to 18 */
           int color) /* BLACK or WHITE */
/* count liberty of color piece at location i, j
   and return value in lib */
{
/* set current piece as marked */
 ml[i][j] = EMPTY;

/* check North neighbor */
 if (i != EMPTY)
   {
    if ((game.p[i - 1][j] == EMPTY) && ml[i - 1][j])
      {
       ++lib;
       ml[i - 1][j] = EMPTY;
     }
    else
       if ((game.p[i - 1][j] == color) && ml[i - 1][j])
	  count(i - 1, j, color);
  }
/* check South neighbor */
 if (i != (game.BoardSize-1))
   {
    if ((game.p[i + 1][j] == EMPTY) && ml[i + 1][j])
      {
       ++lib;
       ml[i + 1][j] = EMPTY;
     }
    else
       if ((game.p[i + 1][j] == color) && ml[i + 1][j])
	  count(i + 1, j, color);
  }
/* check West neighbor */
 if (j != EMPTY)
   {
    if ((game.p[i][j - 1] == EMPTY) && ml[i][j - 1])
      {
       ++lib;
       ml[i][j - 1] = EMPTY;
     }
    else
       if ((game.p[i][j - 1] == color) && ml[i][j - 1])
	  count(i, j - 1, color);
  }
/* check East neighbor */
 if (j != (game.BoardSize-1))
   {
    if ((game.p[i][j + 1] == EMPTY) && ml[i][j + 1])
      {
       ++lib;
       ml[i][j + 1] = EMPTY;
     }
    else
       if ((game.p[i][j + 1] == color) && ml[i][j + 1])
	  count(i, j + 1, color);
  }
}  /* end count */


/*--------------------------------------------
  countlib.c -- Count liberty for single stone
--------------------------------------------*/

void countlib(int m,     /* row number 0 to 18 */
              int n,     /* column number 0 to 18 */
              int color) /* BLACK or WHITE */
/* count liberty of color piece at m, n */
{
 int i, j;

/* set all piece as unmarked */
 for (i = 0; i < (game.BoardSize); i++)
   for (j = 0; j < (game.BoardSize); j++)
     ml[i][j] = 1;

/* count liberty of current piece */
 count(m, n, color);
}  /* end countlib */


/*------------------------------------------------------
  eval.c -- Evaluate liberty of stones in the same color
------------------------------------------------------*/


void eval(int color)  /* BLACK or WHITE */
/* evaluate liberty of color pieces */
 {
  int i, j;

/* find liberty of each piece */
  for (i = 0; i < (game.BoardSize); i++)
    for (j = 0; j < (game.BoardSize); j++)
      if (game.p[i][j] == color)
	{
	 lib = 0;
	 countlib(i, j, color);
     game.l[i][j] = lib;
      }
}  /* end eval */


/*--------------------------------------------------------------------
  exambord.c -- Examine board liberty for one color and update results
--------------------------------------------------------------------*/

void examboard(int color) /* BLACK or WHITE */
/* examine pieces */
{
   int i, j, n;

/* find liberty of each piece */
   eval(color);

/* initialize piece captured */
   if (color == game.mymove)
     {
      game.mik = -1;
      game.mjk = -1;
    }
   else
     {
      game.uik = -1;
      game.ujk = -1;
    }
   n = 0; /* The number of captures this move for Ko purposes */

/* remove all piece of zero liberty */
   for (i = 0; i < (game.BoardSize); i++)
     for (j = 0; j < (game.BoardSize); j++)
       if ((game.p[i][j] == color) && (game.l[i][j] == 0))
	 {
      game.p[i][j] = EMPTY;
      DrawPiece(i,j,EMPTY,FALSE);
/* record piece captured */
      if (color == game.mymove)
	    {
         game.mik = i;
         game.mjk = j;
         ++game.mk;
	   }
	  else
	    {
         game.uik = i;
         game.ujk = j;
         ++game.uk;
	   }
	  ++n;  /* increment number of captures on this move */
	}
/* reset to -1 if more than one stone captured since  no Ko possible */
   if (color == game.mymove && n > 1)
     {
       game.mik = -1;
       game.mjk = -1;
     }
   else if ( n > 1 )
     {
       game.uik = -1;
       game.ujk = -1;
     }
}  /* end examboard */

/*------------------------------------------
  findcolr.c -- Find color of empty location
------------------------------------------*/

unsigned int findcolor(int i,   /* row number 0 to 18 */
                       int j)   /* column number 0 to 18 */
/* find color for empty piece */
{
   int k, result, color[4];

/*
 * return color if all four neighbors are the same or empty
 */

if (game.p[i][j] != EMPTY) return game.p[i][j];


/* check North neighbor */
   if (i>0) {  /* The if prevents reading off edge of board. */
     k = i;
     do --k;
     while ((game.p[k][j] == EMPTY) && (k > 0));
     color[0] = game.p[k][j];
   }
   else color[0] = game.p[i][j];

/* check South neighbor */
   
   if (i<(game.BoardSize-1)) {
     k = i;
     do ++k;
     while ((game.p[k][j] == EMPTY) && (k < (game.BoardSize-1)));
     color[1] = game.p[k][j];
   }
   else color[1] = game.p[i][j];

/* check West neighbor */
   if (j>0) {
     k = j;
     do --k;
     while ((game.p[i][k] == EMPTY) && (k > 0));
     color[2] = game.p[i][k];
   }
   else color[2] = game.p[i][j];

/* check East neighbor */
   if (j<(game.BoardSize-1)) {
     k = j;
     do ++k;
     while ((game.p[i][k] == EMPTY) && (k < (game.BoardSize-1)));
     color[3] = game.p[i][k];
   }
   else color[3] = game.p[i][j];

/* Any nonEMPTY color is what we want */

   for (k=0;k<4;k++) {
     if (color[k] == EMPTY) continue;
        else {
          result = color[k];
          break;
        }
   }

/* We know the right color.  Now cross check it.*/
/* If we find an error then all the dead pieces were not taken 
   from the board and we need to prompt the players to fix this. */

  for (k=0;k<4;k++) {
/* If this next test fails, results are inconsistent.  Problem. */
     if ((color[k] != EMPTY) && (color[k] != result)) return 0;
  }

/* If we get to this point everything checks out OK.  Report results. */

   return result;
}  /* end findcolor */


/*-----------------------------------------------------------------
  findnext.c -- Find next computer move related to current location
-----------------------------------------------------------------*/

static int fval(int newlib, int minlib);

int findnextmove(int m,       /* current stone row number */
                 int n,       /* current stone column number */
                 int *i,      /* next move row number */
                 int *j,      /* next move column number */
                 int *val,    /* next move value */
                 int minlib)  /* current stone liberty */
/* find new move i, j from group containing m, n */
 {
  int ti, tj, tval;
  int found = 0;

  *i = -1;   *j = -1;	*val = -1;
/* mark current position */
  ma[m][n] = 1;

/* check North neighbor */
  if (m != 0)
     if (game.p[m - 1][n] == EMPTY)
      {
       ti = m - 1;
       tj = n;
       lib = 0;
       countlib(ti, tj, game.mymove);
       tval = fval(lib, minlib);
       found = 1;
      }
     else
       if ((game.p[m - 1][n] == game.mymove) && !ma[m - 1][n])
	 if (findnextmove(m - 1, n, &ti, &tj, &tval, minlib))
	    found = 1;

  if (found)
    {
     found = 0;
     if (tval > *val && fioe(ti, tj) != 1)
       {
	*val = tval;
	*i = ti;
	*j = tj;
      }
   }

/* check South neighbor */
  if (m != (game.BoardSize-1))
     if (game.p[m + 1][n] == EMPTY)
      {
       ti = m + 1;
       tj = n;
       lib = 0;
       countlib(ti, tj, game.mymove);
       tval = fval(lib, minlib);
       found = 1;
      }
     else
       if ((game.p[m + 1][n] == game.mymove) && !ma[m + 1][n])
	  if (findnextmove(m + 1, n, &ti, &tj, &tval, minlib))
	     found = 1;

  if (found)
    {
     found = 0;
     if (tval > *val && fioe(ti, tj) != 1)
       {
	*val = tval;
	*i = ti;
	*j = tj;
      }
   }

/* check West neighbor */
  if (n != 0)
     if (game.p[m][n - 1] == EMPTY)
      {
       ti = m;
       tj = n - 1;
       lib = 0;
       countlib(ti, tj, game.mymove);
       tval = fval(lib, minlib);
       found = 1;
      }
     else
       if ((game.p[m][n - 1] == game.mymove) && !ma[m][n - 1])
	  if (findnextmove(m, n - 1, &ti, &tj, &tval, minlib))
	      found = 1;

  if (found)
    {
     found = 0;
     if (tval > *val && fioe(ti, tj) != 1)
       {
	*val = tval;
	*i = ti;
	*j = tj;
      }
   }

/* check East neighbor */
  if (n != (game.BoardSize-1))
     if (game.p[m][n + 1] == EMPTY)
      {
       ti = m;
       tj = n + 1;
       lib = 0;
       countlib(ti, tj, game.mymove);
       tval = fval(lib, minlib);
       found = 1;
      }
     else
       if ((game.p[m][n + 1] == game.mymove) && !ma[m][n + 1])
	  if (findnextmove(m, n + 1, &ti, &tj, &tval, minlib))
	      found = 1;

  if (found)
    {
     found = 0;
     if (tval > *val && fioe(ti, tj) != 1)
       {
	*val = tval;
	*i = ti;
	*j = tj;
      }
   }

 if (*val > 0)	/* found next move */
    return 1;
 else	/* next move failed */
    return 0;
}  /* end findnextmove */

int fval(int newlib,   /* new liberty */
         int minlib)   /* current liberty */
/* evaluate function for new move */
{
 int k, val;

 if (newlib <= minlib)
    val = -1;
 else
   {
    k = newlib - minlib;
    val = 40 + (k - 1) * 50 / (minlib * minlib * minlib);
  }
 return val;
}  /* end fval */


/*-------------------------------------------------------
  findopen.c -- Find possible moves from current location
-------------------------------------------------------*/

int findopen(int m,      /* current row number 0 to 18 */
             int n,      /* current column number 0 to 18 */
             int i[],    /* row array for possible moves */
             int j[],    /* column array for possible moves */
             int color,  /* BLACK or WHITE */
             int minlib, /* current liberty */
             int *ct)    /* number of possible moves */
/* find all open spaces i, j from m, n */
{
/* mark this one */
 ma[m][n] = 1;

/* check North neighbor */
 if (m != 0)
   {
    if ((game.p[m - 1][n] == EMPTY) && (((m - 1) != game.mik) || (n != game.mjk)))
      {
       i[*ct] = m - 1;
       j[*ct] = n;
       ++*ct;
       if (*ct == minlib) return 1;
     }
    else
      if ((game.p[m - 1][n] == color) && !ma[m - 1][n])
	 if (findopen(m - 1, n, i, j, color, minlib, ct) && (*ct == minlib))
	    return 1;
  }

/* check South neighbor */
 if (m != (game.BoardSize-1))
   {
    if ((game.p[m + 1][n] == EMPTY) && (((m + 1) != game.mik) || (n != game.mjk)))
      {
       i[*ct] = m + 1;
       j[*ct] = n;
       ++*ct;
       if (*ct == minlib) return 1;
     }
    else
      if ((game.p[m + 1][n] == color) && !ma[m + 1][n])
	 if (findopen(m + 1, n, i, j, color, minlib, ct) && (*ct == minlib))
	    return 1;
  }

/* check West neighbor */
 if (n != 0)
   {
    if ((game.p[m][n - 1] == EMPTY) && ((m != game.mik) || ((n - 1) != game.mjk)))
      {
       i[*ct] = m;
       j[*ct] = n - 1;
       ++*ct;
       if (*ct == minlib) return 1;
     }
    else
      if ((game.p[m][n - 1] == color) && !ma[m][n - 1])
	 if (findopen(m, n - 1, i, j, color, minlib, ct) && (*ct == minlib))
	    return 1;
  }

/* check East neighbor */
 if (n != (game.BoardSize-1))
   {
    if ((game.p[m][n + 1] == EMPTY) && ((m != game.mik) || ((n + 1) != game.mjk)))
      {
       i[*ct] = m;
       j[*ct] = n + 1;
       ++*ct;
       if (*ct == minlib) return 1;
     }
    else
      if ((game.p[m][n + 1] == color) && !ma[m][n + 1])
	 if (findopen(m, n + 1, i, j, color, minlib, ct) && (*ct == minlib))
	    return 1;
  }

/* fail to find open space */
 return 0;
}  /* end findopen */

/*----------------------------------------------------------------
  findpatn.c -- Find computer move from opening moves and patterns
----------------------------------------------------------------*/

int findpatn(int *i,    /* row number of next move */
             int *j,    /* column number of next move */
             int *val)  /* value of next move */
/* find pattern to match for next move */
{
 int m, n;
 int ti, tj, tval;
 static int cnd, mtype;  /* game tree node number, move type */
/* mtype = 0, basic; 1, inverted; 2, reflected; 3, inverted & reflected */

/* open game then occupy corners */
 if (game.opn[4])   /* continue last move */
   {
    game.opn[4] = 0;  /* clear flag */
    if (opening(i, j, &cnd, mtype)) game.opn[4] = 1; /* more move then reset flag */
    if (game.p[*i][*j] == EMPTY)  /* valid move */
      {
       *val = 80;
       return 1;
     }
    else
      game.opn[4] = 0;
  }

 if (game.opn[0])   /* Northwest corner */
   {
    game.opn[0] = 0;  /* clear flag */
    if (openregion(0, 0, 5, 5))
      {
       cnd = 0;
       mtype = 0;
       opening(i, j, &cnd, mtype);  /* get new node for next move */
       if (opening(i, j, &cnd, mtype)) game.opn[4] = 1;
       *val = 80;
       return 1;
     }
 }

 if (game.opn[1])   /* Southwest corner */
   {
    game.opn[1] = 0;
    if (openregion(13, 0, 18, 5))
      {
       cnd = 0;
       mtype = 1;
       opening(i, j, &cnd, mtype);  /* get new node for next move */
       if (opening(i, j, &cnd, mtype)) game.opn[4] = 1;
       *val = 80;
       return 1;
     }
  }

 if (game.opn[2])   /* Northeast corner */
   {
    game.opn[2] = 0;
    if (openregion(0, 13, 5, 18))
      {
       cnd = 0;
       mtype = 2;
       opening(i, j, &cnd, mtype);  /* get new node for next move */
       if (opening(i, j, &cnd, mtype)) game.opn[4] = 1;
       *val = 80;
       return 1;
     }
  }

 if (game.opn[3])   /* Northeast corner */
   {
    game.opn[3] = 0;
    if (openregion(13, 13, 18, 18))
      {
       cnd = 0;
       mtype = 3;
       opening(i, j, &cnd, mtype);  /* get new node for next move */
       if (opening(i, j, &cnd, mtype)) game.opn[4] = 1;
       *val = 80;
       return 1;
     }
  }

/* occupy edges */
 if (game.opn[5])   /* North edge */
   {
    game.opn[5] = 0;
    if (openregion(0, 6, 4, 11))
      {
       *i = 3;
       *j = 9;
       *val = 80;
       return 1;
     }
  }

 if (game.opn[6])   /* South edge */
   {
    game.opn[6] = 0;
    if (openregion(18, 6, 14, 11))
      {
       *i = (game.BoardSize-4);
       *j = 9;
       *val = 80;
       return 1;
     }
  }

 if (game.opn[7])   /* West edge */
   {
    game.opn[7] = 0;
    if (openregion(6, 0, 11, 4))
      {
       *i = 9;
       *j = 3;
       *val = 80;
       return 1;
     }
  }

 if (game.opn[8])   /* East edge */
   {
    game.opn[8] = 0;
    if (openregion(6, 18, 11, 14))
      {
       *i = 9;
       *j = (game.BoardSize-4);
       *val = 80;
       return 1;
     }
  }

 *i = -1;
 *j = -1;
 *val = -1;

/* find local pattern */
 for (m = 0; m < (game.BoardSize); m++)
   for (n = 0; n < (game.BoardSize); n++)
     if ((game.p[m][n] == game.mymove) &&
         (matchpat(m, n, &ti, &tj, &tval) && (tval > *val)))
       {
        *val = tval;
        *i = ti;
        *j = tj;
      }
 if (*val > 0)  /* pattern found */
    return 1;
 else  /* no match found */
    return 0;
}  /* end findpatn */

/*------------------------------------------------------------------
  findsavr.c -- Find computer next move to defend stones from attack
------------------------------------------------------------------*/

int findsaver(int *i,    /* row number of next move */
              int *j,    /* column number of next move */
              int *val)  /* value of next move */
/* find move if any pieces is threaten */
{
   int m, n, minlib;
   int ti, tj, tval;

   *i = -1;   *j = -1;	 *val = -1;
   for (minlib = 1; minlib < 4; minlib++)
      {
/* count piece with minimum liberty */
       for (m = 0; m < (game.BoardSize); m++)
     for (n = 0; n < (game.BoardSize); n++)
       if ((game.p[m][n] == game.mymove) && (game.l[m][n] == minlib))
/* find move to save pieces */
	     {
	      initmark();
	      if (findnextmove(m, n, &ti, &tj, &tval, minlib) && (tval > *val))
		{
		 *val = tval;
		 *i = ti;
		 *j = tj;
	       }
	     }
     }
    if (*val > 0)   /* find move */
       return 1;
    else	    /* move not found */
       return 0;
 }  /* findsaver */


/*---------------------------------------------------------------
  findwinr.c -- Find computer next move to attack opponent stones
---------------------------------------------------------------*/

int findwinner(int *i,    /* row number of next move */
               int *j,    /* column number of next move */
               int *val)  /* value of next move */
/* find opponent piece to capture or attack */
{
 int m, n, ti[3], tj[3], tval, ct, u, v, lib1;

 *i = -1;   *j = -1;   *val = -1;

/* find opponent with liberty less than four */
 for (m = 0; m < (game.BoardSize); m++)
   for (n = 0; n < (game.BoardSize); n++)
     if ((game.p[m][n] == game.umove) && (game.l[m][n] < 4))
       {
	ct = 0;
	initmark();
    if (findopen(m, n, ti, tj, game.umove, game.l[m][n], &ct))
	  {
       if (game.l[m][n] == 1)
	     {
	      if (*val < 120)
		{
		 *val = 120;
		 *i = ti[0];
		 *j = tj[0];
	       }
	    }
	   else
         for (u = 0; u < (int)game.l[m][n]; u++)
           for (v = 0; v < (int)game.l[m][n]; v++)
		  if (u != v)
		    {
		     lib = 0;
             countlib(ti[u], tj[u], game.mymove);
		     if (lib > 0) /* valid move */
		       {
                        lib1 = lib;
            game.p[ti[u]][tj[u]] = game.mymove;
		    /* look ahead opponent move */
			lib = 0;
            countlib(ti[v], tj[v], game.umove);
			if ((lib1 == 1) && (lib > 0))
                          tval = 0;
                        else
                          tval = 120 - 20 * lib;
			if (*val < tval)
			  {
			   *val = tval;
			   *i = ti[u];
			   *j = tj[u];
			 }
            game.p[ti[u]][tj[u]] = EMPTY;
		      }
		   }
	 }
      }
 if (*val > 0)	/* find move */
    return 1;
 else  /* fail to find winner */
    return 0;
}  /* end findwinner */

/*----------------------------------------------
  fioe.c -- Check if current location is own eye
----------------------------------------------*/

int fioe(int i,   /* stone row number 0 to 18 */
         int j)   /* stone column number 0 to 18 */
{
/* check top edge */
 if (i == 0)
   {
    if ((j == 0) && ((game.p[1][0] == game.mymove) && (game.p[0][1] == game.mymove))) return 1;
    if ((j == (game.BoardSize-1)) && ((game.p[1][(game.BoardSize-1)] == game.mymove) && (game.p[0][(game.BoardSize-2)] == game.mymove))) return 1;
    if ((game.p[1][j] == game.mymove) &&
    ((game.p[0][j - 1] == game.mymove) && (game.p[0][j + 1] == game.mymove))) return 1;
    else
       return 0;
  }
/* check bottom edge */
 if (i == (game.BoardSize-1))
   {
    if ((j == 0) && ((game.p[(game.BoardSize-2)][0] == game.mymove) && (game.p[(game.BoardSize-1)][1] == game.mymove))) return 1;
    if ((j == (game.BoardSize-1)) && ((game.p[(game.BoardSize-2)][(game.BoardSize-1)] == game.mymove) && (game.p[(game.BoardSize-1)][(game.BoardSize-2)] == game.mymove))) return 1;
    if ((game.p[(game.BoardSize-2)][j] == game.mymove) &&
    ((game.p[(game.BoardSize-1)][j - 1] == game.mymove) && (game.p[(game.BoardSize-1)][j + 1] == game.mymove)))
       return 1;
    else
       return 0;
  }
/* check left edge */
 if (j == 0)
    if ((game.p[i][1] == game.mymove) &&
    ((game.p[i - 1] [0] == game.mymove) && (game.p[i + 1][0] == game.mymove)))
       return 1;
    else
       return 0;
/* check right edge */
 if (j == (game.BoardSize-1))
    if ((game.p[i][(game.BoardSize-2)] == game.mymove) &&
    ((game.p[i - 1] [(game.BoardSize-1)] == game.mymove) && (game.p[i + 1][(game.BoardSize-1)] == game.mymove)))
       return 1;
    else
       return 0;
/* check center pieces */
 if (((game.p[i][j - 1] == game.mymove) && (game.p[i][j + 1] == game.mymove)) &&
     ((game.p[i - 1][j] == game.mymove) && (game.p[i + 1][j] == game.mymove)))
    return 1;
 else
    return 0;
}  /* fioe */


/*----------------------------------------
  genmove.c -- Generate computer next move
----------------------------------------*/

#define MAXTRY 400

void genmove(int *i,
             int *j)
/* generate computer move */
{
   int ti, tj, tval;
   char a;
   int ii, m, n, val;
   int try = 0;   /* number of try */

/* initialize move and value */
   *i = -1;  *j = -1;  val = -1;

/* re-evaluate liberty of opponent pieces */
   eval(game.umove);

/* find opponent piece to capture or attack */
   if (findwinner(&ti, &tj, &tval))
       if (tval > val)
	 {
	  val = tval;
	  *i = ti;
	  *j = tj;
	}

/* save any piece if threaten */
   if (findsaver(&ti, &tj, &tval))
       if (tval > val)
	 {
	  val = tval;
	  *i = ti;
	  *j = tj;
	}

/* try match local play pattern for new move */
   if (findpatn(&ti, &tj, &tval))
       if (tval > val)
	 {
	  val = tval;
	  *i = ti;
	  *j = tj;
	}

/* no urgent move then do random move */
   if (val < 0)
       do {
       *i = rand() % (game.BoardSize);

/* avoid low line  and center region */
       if ((*i < 2) || (*i > (game.BoardSize-3)) || ((*i > 5) && (*i < 13)))
	     {
          *i = rand() % (game.BoardSize);
          if ((*i < 2) || (*i > (game.BoardSize-3)))
                *i = rand() % (game.BoardSize);
	    }

           *j = rand() % (game.BoardSize);

/* avoid low line and center region */
       if ((*j < 2) || (*j > (game.BoardSize-3)) || ((*j > 5) && (*j < 13)))
	     {
              *j = rand() % (game.BoardSize);

          if ((*j < 2) || (*j > (game.BoardSize-3)))
                *j = rand() % (game.BoardSize);

	    }
	    lib = 0;
        countlib(*i, *j, game.mymove);
       }
/* avoid illegal move, liberty one or suicide, fill in own eye */
       while ((++try < MAXTRY)
          && ((game.p[*i][*j] != EMPTY) || (lib < 2) || fioe(*i, *j)));

   if (try >= MAXTRY)  /* computer pass */
     {
      game.pass++;
      // printf("I pass.\n");
      // HIER AENDERN
      *i = -1;
    }
   else   /* find valid move */
     {
      game.pass = 0;
      // HIER AENDERN
      // printf("my move: ");
      if (*j < 8)
	 a = *j + 65;
      else
	 a = *j + 66;
      // printf("%c", a);
      ii = (game.BoardSize) - *i;
     // HIER AENDERN
     //  if (ii < 10)
     // printf("%1d\n", ii);
     //  else
     // printf("%2d\n", ii);
    }
}  /* end genmove */

/*----------------------------------------
  initmark.c -- initialize working matrix
----------------------------------------*/

void initmark(void)
/* initialize all marking with zero */
{
int i, j;

  for (i = 0; i < (game.BoardSize); i++)
    for (j = 0; j < (game.BoardSize); j++)
      ma[i][j] = 0;
}  /* end initmark */

/*-----------------------------------
  matchpat.c -- Match pattern moves
-----------------------------------*/


#define abs(x) ((x) < 0 ? -(x) : (x))
#define line(x) (abs(x - 9))

int matchpat(int m,     /* row origin */
             int n,     /* column origin */
             int *i,    /* row number of next move */
             int *j,    /* column number of next move */
             int *val)  /* next move value */
/* match pattern and get next move */
{
/* transformation matrice */
 static int trf [8][2][2] = {
   {{1, 0}, {0, 1}},   /* linear transfomation matrix */
   {{1, 0}, {0, -1}},  /* invert */
   {{0, 1}, {-1, 0}},  /* rotate 90 */
   {{0, -1}, {-1, 0}}, /* rotate 90 and invert */
   {{-1, 0}, {0, 1}},  /* flip left */
   {{-1, 0}, {0, -1}}, /* flip left and invert */
   {{0, 1}, {1, 0}},   /* rotate 90 and flip left */
   {{0, -1}, {1, 0}}   /* rotate 90, flip left and invert */
 };
 int k, my, nx, ll, r, cont;
 int ti, tj, tval;

 *i = -1;   *j = -1;   *val = -1;
 for (r = 0; r < PATNO; r++)
/* try each pattern */
    for (ll = 0; ll < pat[r].trfno; ll++)
/* try each orientation transformation */
      {
       k = 0;  cont = 1;
       while ((k != pat[r].patlen) && cont)
/* match each point */
	 {
/* transform pattern real coordinate */
	  nx = n + trf[ll][0][0] * pat[r].patn[k].x
		 + trf[ll][0][1] * pat[r].patn[k].y;
	  my = m + trf[ll][1][0] * pat[r].patn[k].x
		 + trf[ll][1][1] * pat[r].patn[k].y;

/* outside the board */
      if ((my < 0) || ( my > (game.BoardSize-1)) || (nx < 0) || (nx > (game.BoardSize-1)))
	    {
	     cont = 0;
	     break;
	   }
	  switch (pat[r].patn[k].att) {
      case 0 : if (game.p[my][nx] == EMPTY)  /* open */
		      break;
		   else
		     {
		      cont = 0;
		      break;
		    }
      case 1 : if (game.p[my][nx] == game.umove)  /* your piece */
		      break;
		   else
		     {
		      cont = 0;
		      break;
		    }
      case 2 : if (game.p[my][nx] == game.mymove)  /* my piece */
		      break;
		   else
		     {
		      cont = 0;
		      break;
		    }
      case 3 : if (game.p[my][nx] == EMPTY)  /* open for new move */
		    {
		     lib = 0;
             countlib(my, nx, game.mymove);  /* check liberty */
		     if (lib > 1)  /* move o.k. */
		       {
			ti = my;
			tj = nx;
			break;
		       }
		     else
		       {
			cont = 0;
			break;
		      }
		     }
		   else
		     {
		      cont = 0;
		      break;
		    }
      case 4 : if ((game.p[my][nx] == EMPTY)  /* open on edge */
               && ((my == 0) || (my == (game.BoardSize-1)) || (nx == 0) || (nx == (game.BoardSize-1))))
		      break;
		   else
		     {
		      cont = 0;
		      break;
		    }
      case 5 : if ((game.p[my][nx] == game.umove)  /* your piece on edge */
               && ((my == 0) || (my == (game.BoardSize-1)) || (nx == 0) || (nx == (game.BoardSize-1))))
		      break;
		   else
		     {
		      cont = 0;
		      break;
		    }
      case 6 : if ((game.p[my][nx] == game.mymove)  /* my piece on edge */
               && ((my == 0) || (my == (game.BoardSize-1)) || (nx == 0) || (nx == (game.BoardSize-1))))
		      break;
		   else
		     {
		      cont = 0;
		      break;
		    }
		 }
	  ++k;
	 }
	 if (cont)   /* match pattern */
	   {
	    tval = pat[r].patwt;
	    if ((r >= 8) && (r <= 13))	/* patterns for expand region */
	      {
	       if (line(ti) > 7)  /* penalty on line 1, 2 */
		  tval--;
	       else
		  if ((line(ti) == 6) || (line(ti) == 7))
		     tval++;	/* reward on line 3, 4 */

	       if (line(tj) > 7)  /* penalty on line 1, 2 */
		  tval--;
	       else
		  if ((line(tj) == 6) || (line(tj) == 7))
		     tval++;	/* reward on line 3, 4 */
	     }
	    if (tval > *val)
	      {
	       *val = tval;
	       *i = ti;
	       *j = tj;
	     }
	  }
      }
 if (*val > 0)	/* pattern matched */
    return 1;
 else  /* match failed */
    return 0;
}  /* end matchpat */

/*-----------------------------------
  opening.c -- Select opening moves
-----------------------------------*/

#include <stdlib.h>

int opening(int *i,
            int *j,
            int *cnd,
            int type)
/* get move for opening from game tree */
{
 struct tnode {
   int i, j, ndct, next[8];
  };

 static struct tnode tree[] = {
  {-1, -1, 8, { 1, 2, 3, 4, 5, 6, 7, 20}},	/* 0 */
  {2, 3, 2, { 8, 9}},
  {2, 4, 1, {10}},
  {3, 2, 2, {11, 12}},
  {3, 3, 6, {14, 15, 16, 17, 18, 19}},
  {3, 4, 1, {10}},  /* 5 */
  {4, 2, 1, {13}},
  {4, 3, 1, {13}},
  {4, 2, 0},
  {4, 3, 0},
  {3, 2, 0},  /* 10 */
  {2, 4, 0},
  {3, 4, 0},
  {2, 3, 0},
  {2, 5, 1, {10}},
  {2, 6, 1, {10}},  /* 15 */
  {3, 5, 1, {10}},
  {5, 2, 1, {13}},
  {5, 3, 1, {13}},
  {6, 2, 1, {13}},
  {2, 2, 0}  /* 20 */
};
int m;

/* get i, j */
 if ((type == 1) || (type == 3))
    *i = (game.BoardSize-1) - tree[*cnd].i;   /* inverted */
 else
    *i = tree[*cnd].i;
 if ((type == 2) || (type == 3))
    *j = (game.BoardSize-1) - tree[*cnd].j;   /* reflected */
 else
    *j = tree[*cnd].j;
 if (tree[*cnd].ndct)  /* more move */
   {
    m = rand() % tree[*cnd].ndct;  /* select move */
    *cnd = tree[*cnd].next[m];	/* new	current node */
    return 1;
  }
 else
    return 0;
}  /* end opening */

/*--------------------------------------------------
  openregn.c -- Check if rectangular region is open
---------------------------------------------------*/

int openregion(int i1,
               int j1,
               int i2,
               int j2)
/* check if region from i1, j1 to i2, j2 is open */
{
 int minx, maxx, miny, maxy, x, y;

/* exchange upper and lower limits */

 if (i1 < i2)
   {
    miny = i1;
    maxy = i2;
  }
 else
   {
    miny = i2;
    maxy = i1;
  }

 if (j1 < j2)
   {
    minx = j1;
    maxx = j2;
  }
 else
   {
    minx = j2;
    maxx = j1;
  }

/* check for empty region */
 for (y = miny; y <= maxy; y++)
   for (x = minx; x <= maxx; x++)
     if (game.p[y][x] != EMPTY) return 0;
 return 1;
}  /* end openregion */

/*---------------------------------------------------
  sethand.c -- Set up handicap pieces for black side
----------------------------------------------------*/

void sethand(int i)
/* set up handicap pieces */
{
 if (i > 0)
   {
    game.p[3][3] = BLACK;
    if (i > 1)
      {
       game.p[(game.BoardSize-4)][(game.BoardSize-4)] = BLACK;
       if (i > 2)
	 {
      game.p[3][(game.BoardSize-4)] = BLACK;
	  if (i > 3)
	    {
         game.p[(game.BoardSize-4)][3] = BLACK;
	     if (i == 5)
        game.p[9][9] = BLACK;
	     else
		if (i > 5)
		  {
           game.p[9][(game.BoardSize-4)] = BLACK;
           game.p[9][3] = BLACK;
		   if (i == 7)
              game.p[9][9] = BLACK;
		   else
		      if (i > 7)
			{
             game.p[(game.BoardSize-4)][9] = BLACK;
             game.p[3][9] = BLACK;
			 if (i > 8)
             game.p[9][9] = BLACK;
 			 if (i > 9)
               {game.p[2][2] = 2;
 			    if (i > 10)
                  {game.p[(game.BoardSize-3)][(game.BoardSize-3)] = 2;
 			       if (i > 11)
                 {game.p[2][(game.BoardSize-3)] = 2;
 				  if (i > 12)
                    {game.p[(game.BoardSize-3)][2] = 2;
 				     if (i > 13)
                       {game.p[6][6] = 2;
 					if (i > 14)
                      {game.p[12][12] = 2;
                       if (i > (game.BoardSize-4))
                         {game.p[6][12] = 2;
                          if (i > (game.BoardSize-3))
                        game.p[12][6] = 2;
 					    }
 					 }
 				      }
 				   }
 				}
 			     }
 			  }
		       }
		 }
	   }
	}
     }
  }
}  /* end sethand */


/*----------------------------------------------
  suicide.c -- Check for opponent illegal move
----------------------------------------------*/

int suicide(int i,
            int j)
/* check for suicide move of opponent at game.p[i][j] */
{
 int m, n, k;

/* check liberty of new move */
 lib = 0;
 countlib(i, j, game.umove);
 if (lib == 0)
/* new move is suicide then check if kill my pieces and Ko possibility */
   {
/* assume alive */
    game.p[i][j] = game.umove;

/* check my pieces */
    eval(game.mymove);
    k = 0;

    for (m = 0; m < (game.BoardSize); m++)
      for (n = 0; n < (game.BoardSize); n++)
/* count pieces will be killed */
    if ((game.p[m][n] == game.mymove) && !game.l[m][n]) ++k;

    if ((k == 0) || (k == 1 && ((i == game.uik) && (j == game.ujk))))
/* either no effect on my pieces or an illegal Ko take back */
      {
       game.p[i][j] = EMPTY;   /* restore to open */
       return 1;
      }
    else
/* good move */
      return 0;
   }
 else
/* valid move */
   return 0;
}  /* end suicide */


/* void genmove(int *i,
             int *j)
// generate computer move
{
    *i = rand() % game.BoardSize;
    *j = rand() % game.BoardSize;

    } */


