/*
$Header: /home/koba/pilot/PilotGoJ/src/RCS/showgo.c,v 1.9 2000/08/17 09:59:51 koba Exp $
*/
/*
                     Pilot GO show board routines
                Version 0.22 last revised 9-17-97

               adapted for the USR Pilot & PalmPilot
                  9/10/97 by Matthias von Davier
*/

/*
                 GNUGO - the game of
 Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

           manli@cs.uh.edu

*/

/* SEND MODIFICATIONS of the PILOT version to:
 *
 *         vdavier@ipn.uni-kiel.de
 *
 *
 * Pilot Go
 *
 * by Matthias von Davier
 * september 1997
 */

#include <PalmOS.h>
/*
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
*/

#include "pigoid.h"
#include "pigoty.h"
#include "extvargo.h"


/*************************************************************/
int rand(void)
{   
	return SysRandom(0);
}

/**************************************************************/
void ClearScreen(void)
{
	RectangleType r;
	UInt16 Diam=0;
	r.topLeft.x = 0;
	r.topLeft.y = 0;
	r.extent.x  = 160;
	r.extent.y  = 160;
	WinEraseRectangle(&r,Diam);
}

/**************************************************************/
/*
  Draw marker on last point, or stars
*/
void DrawMarker(int x,int y, unsigned char color)
{
	RectangleType r;

	r.topLeft.x = x*width + offset - 1;
	r.topLeft.y = y*width + offset - 1;
//	r.extent.x  = 3;
	r.extent.y  = r.extent.x = 3;
	if (color==BLACK)
		WinDrawRectangle(&r,0);
	else
		WinEraseRectangle(&r,0);

}

/**************************************************************/
/*
  Draw markers on empty stars.
*/
void DrawMarkers(void)
{
	int start, end, step, i, j;

	/* draw markers for better orientation */
	switch (game.BoardSize)
	{
	case 9:
		start =  2; end   =  6; step  =  2;
		break;
	case 13:
		start =  3; end   =  9; step  =  3;
		break;
		/*case 19:*/
	default:
		start =  3; end   = 15; step  =  6;
		break;
	}

	for (i=start;i<=end;i+=step) {
		for (j=start;j<=end;j+=step) {
			if (game.p[i][j] == EMPTY)
				DrawMarker(i,j,BLACK);
		}
	}
	return;
}


/**************************************************************/
/*
  Draw a stone 
*/
void DrawOnBoard(int x, int y, unsigned char color, UInt16 Size, UInt16 Diam)
{
	int x1,x2,y1,y2;
	RectangleType r;

	r.topLeft.x = x*width + offset - Size;
	r.topLeft.y = y*width + offset - Size;
	//r.extent.x  = 2 * Size + 1;
	r.extent.y  = r.extent.x = 2 * Size + 1;

	WinEraseRectangle(&r,0);
	x1 = y1 = -1;

	switch (color)
	{
	case BLACK:
		WinDrawRectangle(&r,Diam);
		break;
	case WHITE:
		WinDrawRectangle(&r,Diam);
		r.topLeft.x ++;
		r.topLeft.y ++;
		r.extent.x -= 2;
		r.extent.y -= 2;
		WinEraseRectangle(&r,Diam-1);
		break;
	case EMPTY:
	      	
		x1 = x*width + offset - Size - 1;
		x2 = MIN(160-offset,x1 + 2*Size + 2);
		x1 = MAX(offset,x1);
		y1 = y*width + offset;
		WinDrawLine(x1,y1,x2,y1);
		if (x != 0) x1 += (Size + 1);
		y1 -= (Size + 1);
		y2 = MIN(160-offset,y1 + 2*Size+2);
		y1 = MAX(offset,y1);
		WinDrawLine(x1,y1,x1,y2);
		
		break;
	}

}


/**************************************************************/
/*
  Draw a piece and marker (if last one)
 */
void DrawPiece(int x, int y, unsigned char color, Boolean last)
{
	UInt16 Diam = (width / 2) - 1;
	DrawOnBoard(x,y,color,Diam,Diam);

	/*	if this point is last one	*/
	if (last) {
		switch (color) {
		case EMPTY: /*DrawMarkers();*/break;
		case WHITE: DrawMarker(x,y,BLACK); break;
		case BLACK: DrawMarker(x,y,WHITE); break;
		}
	}
	return;
}

/********************************************************/
/*
  Draw whole pieces on board 
 */
void DrawPieces(void)
{
	int i,j;

	for (i=0;i<game.BoardSize; i++) {
		for(j=0;j<game.BoardSize; j++) {
			if (game.p[i][j] != EMPTY) 
				DrawPiece(i,j,game.p[i][j],FALSE);
		}
	}


	return;
}


/**************************************************************/

void DrawDummyPiece(int x, int y, unsigned char color)
{
	UInt16 Diam = (width / 2) - ((game.BoardSize<19)?3:2);
	DrawOnBoard(x,y,color,Diam,Diam);

	return;
}


/**************************************************************/

void EraseDummyPiece(int x, int y)
{
	DrawOnBoard(x,y,EMPTY, width/2-1,3);
	return;
}



/*********************************************************/
void DrawBoard(void)
{
	int i;
	int x1,x2,y1,y2;

	offset = 7; 

	width = (160-2*offset)/(game.BoardSize-1);

	/* recompute due to integer arithmetics */
	offset = (160 - width*(game.BoardSize - 1)) / 2;

	y1=offset;
	y2=160-offset;

	for (i = 0; i < game.BoardSize; i++)
	{
		x1 = offset + i*width;
		/* x2 = x1; */
		WinDrawLine(x1,y1,x1,y2);
	}

	x1 = offset;
	x2 = 160 - offset;

	for (i = 0; i < game.BoardSize; i++)
	{
		y1 = offset + i*width;
		/* y2 = y1; */
		WinDrawLine(x1,y1,x2,y1);
	}
	DrawMarkers();

	return ;
}


/********************************************************/
void ShowBoard(void)
{
	ClearScreen();
	DrawBoard();
	DrawPieces();

	if (game.lastX > -1)
		DrawPiece(game.lastX,game.lastY,game.p[game.lastX][game.lastY],TRUE);

	return ;
}





