/*

$Header: /home/koba/pilot/PilotGoJ/src/RCS/save.c,v 1.4 2000/05/23 09:11:33 koba Exp $
*/
/*		Japanized Pilot GO 
		Version 0.40a0
			by koba (BYH10475@nifty.ne.jp)
		based on Pilot Go 0.31 by Dr. Matthias von Davier 
*/
/*
                     Pilot GO frame program
                Version 0.22 last revised 9-17-97

               adapted for the USR Pilot & PalmPilot
                  9/10/97 by Matthias von Davier
*/

/*

                 GNUGO - the game of Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

           manli@cs.uh.edu

*/

/* SEND MODIFICATIONS of the PILOT version to:
 *
 *         vdavier@ipn.uni-kiel.de
 *
 *
 * Pilot Go
 *
 * by Matthias von Davier
 * september 1997
 */

/*
  Pilot Go J
  By Atsushi Kobayashi (BYH10475@nifty.ne.jp)
  
  Please send modification, bug/fix or comments to me.
*/

#include <PalmOS.h>

/*
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <Preferences.h>
*/

#include "pigoid.h"
#include "pigoty.h"


extern GAME game;
extern int prefStatus;

char            PilotGoDBName[] = "PilotGoJDB";

/*******************************************************************************/

/*
 * Database (here: game status information) handling routines.
 */

Err OpenPreference(void)
{
  Int16	prefret;
  UInt16	prefsize;

  prefret = PrefGetAppPreferencesV10(CREATERID,PREFVERSION,&game,sizeof(GAME));

  if (prefret == FALSE )/*&& 
			  PrefGetAppPreferencesV10(CREATERID,PREFVERSION-1,&game,sizeof(OLD_GAME)) == false)*/ {

    /*	NO PREFERENCES	*/
    /* init game.structure with defaults */
    /*	Default	Setting	*/
    game.Version = 0x40;
    game.Komi = 11;
    game.RulePass =  FALSE;
    game.RuleUndo = TRUE;
    game.RuleSeki = FALSE;
    game.RuleHandicap = TRUE;
    game.RuleSuicide = TRUE;

    game.umove     = BLACK;
    game.mymove    = WHITE;
    game.BoardSize = 19;
    game.mycount = 0;
    game.undocnt = 0;

    game.BlackWhite = (PALM<<2) | HUMAN;

    /*  StrCopy(game.data.Black.Player,"Black"); */
    /*  StrCopy(game.data.White.Player,"White"); */
    
    prefStatus = FALSE;

    Newgame();


    prefsize = sizeof (GAME);

    /*	PrefSetAppPreferencesV10(CREATERID,0,VERSION,&game, prefsize,TRUE);
     */

  } else {


  }

  return 0;

}
	

/**********************************************
 * Save game status information.
 **********************************************/
void SaveStatus(void)
{
  UInt16	prefsize;
  prefsize = sizeof (GAME);
  PrefSetAppPreferencesV10(CREATERID,PREFVERSION,&game, sizeof(GAME));
	
}
	
/***********************************************
 * Save new game record to database	
************************************************/
int SaveNewRecord(void)
{
  DmOpenRef gDB;
  int error;
  MemHandle handle;
  MemPtr memPtr;

  LocalID theDBID;
  UInt16 theAttrs;
  UInt16 theCardNum;
  UInt16 recordIndex = dmMaxRecordIndex;
  DmSearchStateType theSearchState;
	
  if (game.SGFEnable == false) return false;

  gDB = DmOpenDatabaseByTypeCreator(PilotGoDBType,PilotGoAppID,dmModeReadWrite);
  if (!gDB) { /* if no databese -> Create New Database	*/
    error = DmCreateDatabase(0,PilotGoDBName,PilotGoAppID,PilotGoDBType,
			     false);
    if (error) return error;
		
    gDB = DmOpenDatabaseByTypeCreator(PilotGoDBType,PilotGoAppID,dmModeReadWrite);
    if (!gDB) { /* Can not open Database	*/
      return DmGetLastErr();
    }
  }

  /*	Save New Record	*/
  handle = DmNewRecord(gDB,&recordIndex,sizeof(STOREDATA));
  memPtr = MemHandleLock(handle);
  DmWrite(memPtr,0,&game.data,sizeof(STOREDATA));
  MemHandleUnlock(handle);
  DmReleaseRecord(gDB,recordIndex,true);
  error = DmCloseDatabase(gDB);


  /*	Set backup bit	*/
  error = DmGetNextDatabaseByTypeCreator( true, &theSearchState, PilotGoDBType,
					  PilotGoAppID, true, &theCardNum, &theDBID );
  // Find out what the DB ID and Card Number of our database are
  if (!error) {
    // Get the attributes for our database
    DmDatabaseInfo(theCardNum, theDBID, NULL, &theAttrs, NULL, NULL,
		   NULL, NULL, NULL, NULL, NULL, NULL, NULL);
               
    // Set the backup flag
    theAttrs |= dmHdrAttrBackup;

    // Set the attributes
    DmSetDatabaseInfo(theCardNum, theDBID, NULL, &theAttrs, NULL, NULL,
		      NULL, NULL, NULL, NULL, NULL, NULL, NULL);
  }
  
  return error;
}






