/*
$Header: /home/koba/pilot/PilotGoJ/src/RCS/prefs.c,v 1.5 2000/05/11 00:49:59 koba Exp $
*/
/*		Japanized Pilot GO 
		Version 0.40a0
			by koba (BYH10475@nifty.ne.jp)
		based on Pilot Go 0.31 by Dr. Matthias von Davier 
*/
/*
                     Pilot GO frame program
                Version 0.22 last revised 9-17-97

               adapted for the USR Pilot & PalmPilot
                  9/10/97 by Matthias von Davier
*/

/*

                 GNUGO - the game of Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

           manli@cs.uh.edu

*/

/* SEND MODIFICATIONS of the PILOT version to:
 *
 *         vdavier@ipn.uni-kiel.de
 *
 *
 * Pilot Go
 *
 * by Matthias von Davier
 * september 1997
 */

/*
	Pilot Go J
		By Atsushi Kobayashi (BYH10475@nifty.ne.jp)

	Please send modification, bug/fix or comments to me.
*/

#include <PalmOS.h>
/*
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <Preferences.h>
*/

#include "pigoid.h"
#include "pigoty.h"
#include "callback.h"


extern int prefStatus;

extern GAME game;


Boolean PilotGoPrefsEvent(EventPtr event);
Boolean PilotGoInfo1Event(EventPtr event);
Boolean PilotGoInfo2Event(EventPtr event);


static void SetPrefStatus(FormPtr form);

static FieldPtr SetFieldTextFromHandle( UInt16 fieldID,MemHandle txtH);
static FieldPtr SetFiedlTextFromStr(UInt16 fieldID,Char *buff);
static void ClearFieldText(UInt16 fieldID);


/**************************************************************************/
/*	variables for Preferences	*/
static ControlPtr ctlSize9,ctlSize13,ctlSize19;
static ControlPtr ctlBlHuman,ctlBlComp,ctlWhHuman,ctlWhComp;
static ControlPtr ctlHandi0,ctlHandi2, ctlHandi3, ctlHandi4, ctlHandi5,
  ctlHandi6, ctlHandi7, ctlHandi8, ctlHandi9;
static ControlPtr ctlKomi;
static ControlPtr ctlSGFEnable;
static ControlPtr ctlSndEnable;
static ControlPtr ctlPassEnable;
static ControlPtr ctlUndoEnable;

static int	prefSize,prefBlack,prefWhite,prefHandicap,prefKomi;
static int	prefPassEnable,prefUndoEnable,prefSGFEnable,prefSndEnable;



/*****************************************************/
static void PrefsRestore(void)
{
  /*	Board Size	*/
  switch(prefSize) {
  case 9: CtlSetValue(ctlSize9,true); break;
  case 13: CtlSetValue(ctlSize13,true); break;
  default: CtlSetValue(ctlSize19,true); break;
  }

  /*	BlackWhite	*/
  /*	black	*/
  if (prefBlack== HUMAN)	{
    CtlSetValue(ctlBlHuman,true); 
  } else {
    CtlSetValue(ctlBlComp,true); 
  }
  /*	white	*/
  if (prefWhite == HUMAN) {
    CtlSetValue(ctlWhHuman,true); 
  } else {
    CtlSetValue(ctlWhComp,true); 
  }
		
  /*	Handicap	*/
  switch (prefHandicap) {
  case 0: CtlSetValue(ctlHandi0,true);break;
  case 2: CtlSetValue(ctlHandi2,true);break;
  case 3: CtlSetValue(ctlHandi3,true);break;
  case 4: CtlSetValue(ctlHandi4,true);break;
  case 5: CtlSetValue(ctlHandi5,true);break;
  case 6: CtlSetValue(ctlHandi6,true);break;
  case 7: CtlSetValue(ctlHandi7,true);break;
  case 8: CtlSetValue(ctlHandi8,true);break;
  case 9: CtlSetValue(ctlHandi9,true);break;
  }

  /*	Pass	*/
  CtlSetValue(ctlPassEnable,prefPassEnable);
  /*	Undo	*/
  CtlSetValue(ctlUndoEnable,prefUndoEnable);
  /*	Store SGF data	*/
  CtlSetValue(ctlSGFEnable,prefSGFEnable);
  /*	Sound Enable	*/
  CtlSetValue(ctlSndEnable,prefSndEnable);

  /*	Not Implemented	*/

  return;
}




/*****************************************************/
static void SetPrefStatus(FormPtr form)
{

  /*	Get pointers of controls	*/
  /*	Board Size	*/
  ctlSize9 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Size9));
  ctlSize13 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Size13));
  ctlSize19 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Size19));
  /*	BlackWhite	*/
  ctlBlHuman = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_BlHuman));
  ctlBlComp = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_BlComp));
  ctlWhHuman = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_WhHuman));
  ctlWhComp = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_WhComp));
  /*	Handicap	*/
  ctlHandi0 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi0));
  ctlHandi2 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi2));
  ctlHandi3 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi3));
  ctlHandi4 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi4));
  ctlHandi5 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi5));
  ctlHandi6 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi6));
  ctlHandi7 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi7));
  ctlHandi8 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi8));
  ctlHandi9 = FrmGetObjectPtr(form,FrmGetObjectIndex(form,pbID_Handi9));
  /*	Pass	*/
  ctlPassEnable = FrmGetObjectPtr(form,FrmGetObjectIndex(form,cbID_PassEnable));
  /*	Undo	*/
  ctlUndoEnable = FrmGetObjectPtr(form,FrmGetObjectIndex(form,cbID_UndoEnable));
  /*	Not Implemented	*/
  ctlKomi = FrmGetObjectPtr(form,FrmGetObjectIndex(form,liID_Komi));
  /*    Store SGF Data */
  ctlSGFEnable = FrmGetObjectPtr(form,FrmGetObjectIndex(form,cbID_SGFEnable));
  /*    Sound Enable */
  ctlSndEnable = FrmGetObjectPtr(form,FrmGetObjectIndex(form,cbID_SndEnable));
	

  if (prefStatus) {
    prefStatus = false;
    PrefsRestore();
    return;
  }


  /*	Board Size	*/
  switch(prefSize = game.BoardSize) {
  case 9: CtlSetValue(ctlSize9,true); break;
  case 13: CtlSetValue(ctlSize13,true); break;
  default: CtlSetValue(ctlSize19,true); break;
  }

  /*	BlackWhite	*/
  /*	black	*/
  if ((game.BlackWhite & 0x003)== HUMAN)	{
    prefBlack = HUMAN;
    CtlSetValue(ctlBlHuman,true); 
  } else {
    prefBlack = PALM;
    CtlSetValue(ctlBlComp,true); 
  }
  /*	white	*/
  if (((game.BlackWhite>>2)& 0x003) == HUMAN) {
    prefWhite = HUMAN;
    CtlSetValue(ctlWhHuman,true); 
  } else {
    prefWhite = PALM;
    CtlSetValue(ctlWhComp,true); 
  }
		
  /*	Handicap	*/
  switch (prefHandicap = game.handicap) {
  case 0: CtlSetValue(ctlHandi0,true);break;
  case 2: CtlSetValue(ctlHandi2,true);break;
  case 3: CtlSetValue(ctlHandi3,true);break;
  case 4: CtlSetValue(ctlHandi4,true);break;
  case 5: CtlSetValue(ctlHandi5,true);break;
  case 6: CtlSetValue(ctlHandi6,true);break;
  case 7: CtlSetValue(ctlHandi7,true);break;
  case 8: CtlSetValue(ctlHandi8,true);break;
  case 9: CtlSetValue(ctlHandi9,true);break;
  }

  /*	Pass	*/
  CtlSetValue(ctlPassEnable,game.RulePass);
  /*	Undo	*/
  CtlSetValue(ctlUndoEnable,game.RuleUndo);
  /*    SGF Enable */
  CtlSetValue(ctlSGFEnable,game.SGFEnable);
  /*    Sound  Enable */
  CtlSetValue(ctlSndEnable,game.SndEnable);

  /*	Not Implemented	*/

  return;
}


/************************************************/
/*	Event Handler for Preference		*/
/************************************************/
Boolean PilotGoPrefsEvent(EventPtr event)
{
  FormPtr	form;
  int	handled = 0;

  CALLBACK_PROLOGUE

    switch (event->eType) {
    case frmOpenEvent:
      form = FrmGetActiveForm();
      SetPrefStatus(form);
      FrmDrawForm(form);
      handled = 1;
      break;
    case ctlSelectEvent:
      switch (event->data.ctlSelect.controlID) {
	/*	Board Size	*/
      case pbID_Size9: prefSize = 9; break;
      case pbID_Size13: prefSize = 13; break;
      case pbID_Size19: prefSize = 19; break;
	/*	Black White	*/
      case pbID_BlHuman: prefBlack = HUMAN; break;
      case pbID_BlComp: 
	prefBlack = PALM; prefWhite = HUMAN; 
	CtlSetValue(ctlWhHuman,true);
	CtlSetValue(ctlWhComp,false);
	break;
      case pbID_WhHuman: prefWhite = HUMAN; break;
      case pbID_WhComp: 
	prefWhite = PALM; prefBlack = HUMAN; 
	CtlSetValue(ctlBlHuman,true);
	CtlSetValue(ctlBlComp,false);
	break;
	/*	Handicap	*/
      case pbID_Handi0: prefHandicap = 0; break;
      case pbID_Handi2: prefHandicap = 2; break;
      case pbID_Handi3: prefHandicap = 3; break;
      case pbID_Handi4: prefHandicap = 4; break;
      case pbID_Handi5: prefHandicap = 5; break;
      case pbID_Handi6: prefHandicap = 6; break;
      case pbID_Handi7: prefHandicap = 7; break;
      case pbID_Handi8: prefHandicap = 8; break;
      case pbID_Handi9: prefHandicap = 9; break;
	/*	PassRule	*/
      case cbID_PassEnable:
	prefPassEnable = CtlGetValue(ctlPassEnable); break;
	/*	UndoRule	*/
      case cbID_UndoEnable: 
	prefUndoEnable = CtlGetValue(ctlUndoEnable); break;
	/*	Store SGF data	*/
      case cbID_SGFEnable: 
	prefSGFEnable = CtlGetValue(ctlSGFEnable);break;
	/*	Sound Enable	*/
      case cbID_SndEnable: 
	prefSndEnable = CtlGetValue(ctlSndEnable);break;
		
	/*	not inplemented	*/
      case liID_Komi: break;

	/*	Set information	*/
      case btID_SetSGFInfo1:
	prefStatus=true;
	FrmGotoForm(formID_SGFInfo1);
	handled = 1;
	break;

	/*	Set information	*/
      case btID_SetSGFInfo2:
	prefStatus=true;
	FrmGotoForm(formID_SGFInfo2);
	handled = 1;
	break;

	/*	OK!	*/
      case pbID_New:
	game.BoardSize = prefSize;
	game.BlackWhite = (prefWhite<<2) | prefBlack;
	game.handicap = prefHandicap;
	game.RulePass = CtlGetValue(ctlPassEnable);
	game.RuleUndo = CtlGetValue(ctlUndoEnable);
	game.SGFEnable = CtlGetValue(ctlSGFEnable);
	game.SndEnable = CtlGetValue(ctlSndEnable);
	prefStatus=true;
	FrmGotoForm(formID_PilotGo);
	handled = 1;
	break;

	/*	Canceled	*/
      case pbID_Cancel:
	prefStatus=false;
	FrmGotoForm(formID_PilotGo);
	handled = 1;
	break;
      }
      break;
    case nilEvent:
      handled = 1;
      break;
    default:
      break;
    }

  CALLBACK_EPILOGUE

    return handled;
}


/*****************************************************/
static void SetInfo1Status(FormPtr form)
{
  return;
}

/************************************************/
/*	Event Handler for info1	*/
/************************************************/
Boolean PilotGoInfo1Event(EventPtr event)
{
  FormPtr	form;
  int	handled = 0;
/*
  CALLBACK_PROLOGUE

    switch (event->eType) {
    case frmOpenEvent:
      form = FrmGetActiveForm();
      SetInfo1Status(form);
      FrmDrawForm(form);
      handled = 1;
      break;
    case ctlSelectEvent:
      switch (event->data.ctlSelect.controlID) {
      case fldID_Event:
	SetFiedlTextFromStr(fldID_Event,"Event!");
	break;
      case fldID_Round:
	SetFiedlTextFromStr(fldID_Round,"Round!");
	break;

//		OK!	
      case pbID_New:
	FrmGotoForm(formID_Prefs);
	handled = 1;
	break;

//		Canceled	
      case pbID_Cancel:
	FrmGotoForm(formID_Prefs);
	handled = 1;
	break;
      }
      break;
    case nilEvent:
      handled = 1;
      break;
    default:
      break;
    }

  CALLBACK_EPILOGUE
*/
    return handled;
}

/*****************************************************/
static void SetInfo2Status(FormPtr form)
{
  return;
}

/************************************************/
/*	Event Handler for info1	*/
/************************************************/
Boolean PilotGoInfo2Event(EventPtr event)
{
  FormPtr	form;
  int	handled = 0;
/*
  CALLBACK_PROLOGUE

    switch (event->eType) {
    case frmOpenEvent:
      form = FrmGetActiveForm();
      SetInfo2Status(form);
      FrmDrawForm(form);
      handled = 1;
      break;
    case ctlSelectEvent:
      switch (event->data.ctlSelect.controlID) {

	//	OK!	
      case pbID_New:
	FrmGotoForm(formID_Prefs);
	handled = 1;
	break;

	//	Canceled	
      case pbID_Cancel:
	FrmGotoForm(formID_Prefs);
	handled = 1;
	break;
      }
      break;
    case nilEvent:
      handled = 1;
      break;
    default:
      break;
    }

  CALLBACK_EPILOGUE
*/
    return handled;
}




/****************************************************************/
static FieldPtr SetFieldTextFromHandle(UInt16 fieldID,MemHandle txtH)
{

  MemHandle prevHandle;
  FormPtr frm = FrmGetActiveForm();
  FieldPtr fldP;
/*  
  fldP = FrmGetObjectPtr(frm,FrmGetObjectIndex(frm,fieldID));
  ErrNonFatalDisplayIf(!fldP,"missing field");
  prevHandle = FldGetTextHandle(fldP);

  FldSetTextHandle(fldP,txtH);
  FldDrawField(fldP);

  if (prevHandle)	MemHandleFree(prevHandle);
*/
  return fldP;
}



/****************************************************************/
static FieldPtr SetFiedlTextFromStr(UInt16 fieldID,Char *buff)
{
  MemHandle txtH;
  /*
  txtH = MemHandleNew(StrLen(buff) + 1);
  if (!txtH) return NULL;

  StrCopy(MemHandleLock(txtH),buff);
	
  MemHandleUnlock(txtH);
  */
  return SetFieldTextFromHandle(fieldID,txtH);

}
	

/****************************************************************/
static void ClearFieldText(UInt16 fieldID)
{
/*
  SetFieldTextFromHandle(fieldID,NULL);
*/ 
 return;
}













