/*
$Header: /home/koba/pilot/PilotGoJ/src/RCS/pilotgo.c,v 1.15 2000/04/13 13:08:07 koba Exp $
*/
/*		Japanized Pilot GO 
		Version 0.40a0
			by koba (BYH10475@nifty.ne.jp)
		based on Pilot Go 0.31 by Dr. Matthias von Davier 
*/
/*
                     Pilot GO frame program
                Version 0.22 last revised 9-17-97

               adapted for the USR Pilot & PalmPilot
                  9/10/97 by Matthias von Davier
*/

/*

                 GNUGO - the game of Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber


This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

           manli@cs.uh.edu

*/

/* SEND MODIFICATIONS of the PILOT version to:
 *
 *         vdavier@ipn.uni-kiel.de
 *
 *
 * Pilot Go
 *
 * by Matthias von Davier
 * september 1997
 */

/*
	Pilot Go J
		By Atsushi Kobayashi (BYH10475@nifty.ne.jp)

	Please send modification, bug/fix or comments to me.
*/

#include <PalmOS.h>

/*
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <Preferences.h>
*/

#include "pigoid.h"
#include "pigoty.h"
#include "callback.h"


Err OpenPreference(void);
void SaveStatus(void);

static int StartApplication(void);
static void EventLoop(void);
static void StopApplication(void);

Boolean PilotGoMainEvent(EventPtr event);
Boolean PilotGoPrefsEvent(EventPtr event);
Boolean PilotGoInfo1Event(EventPtr event);
Boolean PilotGoInfo2Event(EventPtr event);




/********************************************************************/
UInt32  PilotMain (UInt16 cmd, MemPtr cmdPBP, UInt16 launchFlags)
{
	int error;

	if (cmd == sysAppLaunchCmdNormalLaunch)
	{

		error = StartApplication();	
		// Application start code
		if (error) return error;

		EventLoop();	
		// Event loop

		StopApplication ();	
		// Application stop code
	}
	return 0;
}



/********************************************************************/
static int StartApplication(void)
{
	int error;

	error = OpenPreference();
	if (error) return error;
	FrmGotoForm(formID_PilotGo);
	return error;
}

/********************************************************************/
static void EventLoop(void)
{
	short err;
	int formID;
	FormPtr form;
	EventType event;

	do
	{

		EvtGetEvent(&event, 200);

		if (SysHandleEvent(&event)) continue;
		if (MenuHandleEvent((void *)0, &event, &err)) continue;

		if (event.eType == frmLoadEvent)
		{
			formID = event.data.frmLoad.formID;
			form = FrmInitForm(formID);
			FrmSetActiveForm(form);
			switch (formID) {
			/*	menu	*/
			case formID_PilotGo:
				FrmSetEventHandler(form, 
					(FormEventHandlerPtr) PilotGoMainEvent);
				break;

			/*	preference	*/
			case formID_Prefs:
				FrmSetEventHandler(form, 
					(FormEventHandlerPtr) PilotGoPrefsEvent);
				break;

			/*	information 1	*/
			case formID_SGFInfo1:
				FrmSetEventHandler(form, 
					(FormEventHandlerPtr) PilotGoInfo1Event);
				break;

			/*	information 2	*/
			case formID_SGFInfo2:
				FrmSetEventHandler(form, 
					(FormEventHandlerPtr) PilotGoInfo2Event);
				break;


			}
		}
		FrmDispatchEvent(&event);
	} while(event.eType != appStopEvent);
}

/********************************************************************/
static void StopApplication(void)
{
	FrmCloseAllForms();
	SaveStatus();
}




