/*
$Header: /home/koba/pilot/PilotGoJ/src/RCS/pigoty.h,v 1.12 2000/08/17 12:11:45 koba Exp $
*/
/*------------------------------
  pigoTY.h -- Pilot GO common header file
------------------------------*/
#include "proto.h"

/* definitions */

#define EMPTY 0
#define WHITE 1
#define BLACK 2

#define	HUMAN 0
#define	PALM  1

#define ENDGAME     0
#define PLAY        1
//#define HANDICAP    2
#define REMOVEDEAD  3
#define FILLNEUTRAL 4

#define TRUE  1
#define FALSE 0

#define PilotGoAppID    CREATERID
#define PilotGoDBType   'DATA'   // 0x64415441 in hexadecimal
#define	PiltoGoDBName	"PGoJDB"

#define	ENGLISH	0
#define	JAPANESE	1

#define	UNDOMAX	4

#define BUFF_SIZE_VERSION       8
#define	BUFF_SIZE_PLAYER	32
#define	BUFF_SIZE_RANK		8
#define	BUFF_SIZE_TEAM		32
#define	BUFF_SIZE_POS 		512
#define BUFF_SIZE_KOMI          8
#define	BUFF_SIZE_DATE		32
#define	BUFF_SIZE_EVENT		32
#define	BUFF_SIZE_RESULT	16
#define	BUFF_SIZE_ROUND		16
#define	BUFF_SIZE_PLACE		32
#define	BUFF_SIZE_RULES		16
#define	BUFF_SIZE_GAMENAME	32
#define	BUFF_SIZE_OPENING	16
#define	BUFF_SIZE_GAMECOMMENT	64
#define	BUFF_SIZE_SOURCE	32
#define	BUFF_SIZE_USER		32
#define	BUFF_SIZE_ANNOTATION	32
#define	BUFF_SIZE_COPYRIGHT	32

#define MAX(x,y)        ((x>y) ? x : y)
#define MIN(x,y)        ((x>y) ? y : x)

#define	fioe(i,j)	check_eye(i,j,game.mymove)
#define	FIOE


#define HANDICAP  4
#define TIME  8

/*      */
#define	SET_POS(mode,i,j)	(((mode) << 12) | (((i)&0x1f)<<5) | ((j)&0x1f) )
#define MODE_POS(i) ((i)>>12)
#define I_POS(i) (((i) >>5) & 0x001F)
#define J_POS(i) ((i) & 0x001F)

typedef	struct	{
	char	Player[BUFF_SIZE_PLAYER];
	char	Rank[BUFF_SIZE_RANK];
	char	Team[BUFF_SIZE_TEAM];
}	PLAYER_INFO;

typedef	struct	{
	short	Size;
	short	Version;
	short	Handicap;
	short	Time;
	char    PGOJVersion[BUFF_SIZE_VERSION];
	char	Date[BUFF_SIZE_DATE];
	char	Event[BUFF_SIZE_EVENT];
	char	Result[BUFF_SIZE_RESULT];
	char	Komi[BUFF_SIZE_KOMI];
	char	Round[BUFF_SIZE_ROUND];
	char	Place[BUFF_SIZE_PLACE];
	char	Rules[BUFF_SIZE_RULES];
	char	GameName[BUFF_SIZE_GAMENAME];
	char	Opening[BUFF_SIZE_OPENING];
	char	GameComment[BUFF_SIZE_GAMECOMMENT];
	char	Source[BUFF_SIZE_SOURCE];
	char	User[BUFF_SIZE_USER];
	char	Annotation[BUFF_SIZE_ANNOTATION];
	char	Copyright[BUFF_SIZE_COPYRIGHT];
	PLAYER_INFO 	Black;
	PLAYER_INFO	White;
	short   NumberOfTurn;
	short	pos[BUFF_SIZE_POS];
}	STOREDATA;


/* public types */
//	PREFVERSION == 6
typedef struct {
	int	Version;
	int	Size;

	unsigned char   SGFEnable;
	unsigned char	Komi;
	unsigned char	RulePass;
	unsigned char	RuleUndo;
	unsigned char	RuleSeki;
	unsigned char	RuleHandicap;
	unsigned char	RuleSuicide;
	unsigned char	BlackWhite;
	unsigned char	UndoCount;
	unsigned char   SndEnable;
	STOREDATA	data;

	unsigned char p[19][19];
	unsigned char l[19][19];
	unsigned char ng[19][19];
	unsigned char undo[19][19];
	int mymove,umove;
	int lib;
	int play;	/*	status of play	*/
	int pass;	/*	number of pass	*/
	int opn[9];
	int mk; 	/*	computer's killed pieces	*/
	int uk;		/*	human's killed pieces		*/
	int mik, mjk;	/*	computer's lask killed posission	*/
	int uik, ujk;	/*	human's last killed posission 		*/
	int BoardSize, offset, width, handicap;
	int lastX,lastY;/*	lastX, lastY	*/
	int fill;
	int time;
	int mycount;
	int undocnt;
	int mycount_undo[UNDOMAX];
	int lastX_undo[UNDOMAX];
	int lastY_undo[UNDOMAX];
	int mk_undo[UNDOMAX];
	int uk_undo[UNDOMAX];
	int mik_undo[UNDOMAX];
	int mjk_undo[UNDOMAX];
	int uik_undo[UNDOMAX];
	int ujk_undo[UNDOMAX];

} GAME , OLD_GAME;










