/*
  $header$
 */


/* struct for pdb file */
#ifdef BIGENDIAN
/* header for pdb */
typedef struct {
  char dbname[32];
  short flags;
  short version;
  long create_time;
  long modified_time;
  long backup_time;
  long modified_number;
  long app_info_size;
  long sort_info_size;
  long type;
  long createrID;
  long unique_id_seed;
  long next_record_list;
  short number_of_records;
} PDB_HEADER;

/* record database element */
typedef struct {
  long offset;
  char attributes;
  char uniqueID[3];
} RECORD_ELEMENT;


/* resource database element */
typedef struct {
  char resoruce_type[4];
  short resourceID;
  long offset_next_resource;
} RESOURCE_ELEMENT;

#else

typedef unsigned char uchar;

/* header for pdb */
typedef struct {
  char dbname[32];
  uchar flags[2];
  uchar version[2];
  uchar create_time[4];
  uchar modified_time[4];
  uchar backup_time[4];
  uchar modified_number[4];
  uchar app_info_size[4];
  uchar sort_info_size[4];
  uchar type[4];
  uchar createrID[4];
  uchar unique_id_seed[4];
  uchar next_record_list[4];
  uchar number_of_records[2];
} PDB_HEADER;

/* record database element */
typedef struct {
  uchar offset[4];
  char attributes;
  char uniqueID[3];
} RECORD_ELEMENT;


/* resource database element */
typedef struct {
  char resoruce_type[4];
  uchar resourceID[2];
  uchar offset_next_resource[4];
} RESOURCE_ELEMENT;

#endif /* end of BIGENDIAN */



  




