/*
  $header$
*/

/*
  Usage:
  pdb2sgf [-s sgf_filename] [filename.pdb]

  If filename.pdb does not exist, read through standard input.

  SGF filename
    default : pgojXXXX.sgf
    -s :  sgf_filename
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pdb2sgf.h"
#include "../pigoty.h"

#define BUFF_SIZE 2048

char *src_file;
char src_file_default[]="PilotGoJDB.PDB";
char dest_file[BUFF_SIZE];
char *dest_file_head;
char dest_file_head_default[] = "pgoj";

int main(int argc, char *argv[]);
int check_args(int argc,char *argv[]);
void usage (void);
int conv_to_sgf(STOREDATA rec_data,int num);
void ToLittleEndian (STOREDATA *rec_dat);
int ToLE_Sub(void *ptr, int size);


/************************************************/
int main(int argc, char *argv[])
{
	FILE *fpin;
	PDB_HEADER pdb_header;
	RECORD_ELEMENT rec_ele;
	short dummy;
	STOREDATA  rec_data;

	int rec_cnt=0,rec_cnt_max;

	/* check arguments */
	src_file = NULL;
	if (check_args(argc,argv) == FALSE)
		usage();

	/* open stream for input */
	if (src_file != NULL) {
		fpin = fopen (src_file,"rb");
		if (fpin == NULL) {
			fprintf(stderr,"Can not open file:%s\n",src_file);
			exit(FALSE);
		} 
	} else 
		fpin = stdin;
 

	/* read pdb header */
	fread(&pdb_header, sizeof(PDB_HEADER),1,fpin);
  
	/* check pdb status */
	fprintf(stderr,"number of records:%i\n",rec_cnt_max = pdb_header.number_of_records[0]*256 + pdb_header.number_of_records[1]);

	/* read record element */
	while (rec_cnt < rec_cnt_max) {
		fread(&rec_ele,sizeof(rec_ele),1,fpin);    
		//fprintf(stderr,"rec_cnt:%i %i %s\n",rec_cnt,sizeof(rec_ele),dest_file);
		rec_cnt++;
	}
	// read 2bytes of 0
	fread (&dummy,2,1,fpin);

	rec_cnt = 0;

	/* read pdb records */
	while (rec_cnt < rec_cnt_max) {
		fread(&rec_data,sizeof(rec_data),1,fpin);    
		conv_to_sgf(rec_data,rec_cnt);
		rec_cnt++;
	}

	/* ending */
	if (fpin != stdin) fclose(fpin);

	return TRUE;
}

/************************************************/
/* analyzing comand line options */
/*********************************/
int check_args(int argc,char *argv[])
{
	int argc1 = 0;
	
	fprintf(stderr,"Checking arguments.\n");
	src_file = src_file_default;
	dest_file_head = dest_file_head_default;
	
	if (argc > 4) usage();
	
	if (argc > 1) {
		/* check -s option */
		if (strncmp(argv[1],"-s",10) == 0){
			dest_file_head = argv[argc1+2];
			argc1 += 2;
		}
		argc1 ++;
		/* check src file name */
		if ((argc > 1) & (argc1 == argc -1))
			src_file = argv[argc1];
	}
	
	fprintf(stderr,"src:%s\n",src_file);
	
	return TRUE;
}

/*************************************************/
/* usage */
/*********/
void usage (void)
{
	fprintf (stderr,"pdb2sgf [-s name] [PiGoJDB.PDB]\n");
	
	exit(FALSE);
}

/**************************************************/
/* convert to sgf */
/******************/
int conv_to_sgf(STOREDATA rec_data,int num)
{
	FILE *fpout;
	int i;
	
#ifdef LITTLE_ENDIAN
	ToLittleEndian(&rec_data);
#endif /* LITTLE_ENDIAN */

	/* generate file name */
	strcpy(dest_file,dest_file_head);
	sprintf((dest_file + strlen(dest_file_head)),
		"%04i",num);
	strcat(dest_file,".sgf");
	fprintf (stderr,"Record %i: %s\n",num,dest_file);

	/* open file */
	fpout = fopen(dest_file,"w");
	if (fpout == NULL) {
		fprintf(stderr,"Can't open file:%s\n",dest_file);
		return FALSE;
	}

	/* debug */

	/* write data */
	/* root property */
	fprintf(fpout,"(;FF[4]GM[1]");
	fprintf(fpout,"AP[PilotGoJ:%s]",rec_data.PGOJVersion);
	fprintf(fpout,"SZ[%i]\n",rec_data.Size);


	/* Game Information Property */
	fprintf(fpout,"(");
	fprintf(fpout,";GN[%s]",rec_data.GameName);
	fprintf(fpout,"EV[%s]",rec_data.Event);
	fprintf(fpout,"RO[%s]",rec_data.Round);
	//fprintf(fpout,"RU[%s]",rec_data.Rules);
	fprintf(fpout,"CP[%s]",rec_data.Copyright);
	fprintf(fpout,"AN[%s]",rec_data.Annotation);
	fprintf(fpout,"BR[%s]",rec_data.Black.Rank);
	fprintf(fpout,"WR[%s]",rec_data.White.Rank);
	fprintf(fpout,"BT[%s]",rec_data.Black.Team);
	fprintf(fpout,"WT[%s]",rec_data.White.Team);
	fprintf(fpout,"PB[%s]",rec_data.Black.Player);
	fprintf(fpout,"PW[%s]\n",rec_data.White.Player);

	fprintf(fpout,"RE[%s]",rec_data.Result);
	fprintf(fpout,"DT[%s]",rec_data.Date);
	fprintf(fpout,"TM[%i]",rec_data.Time);
	fprintf(fpout,"KM[%s]",rec_data.Komi);

	//  fwrite(&rec_data,sizeof(rec_data),1,fpout);
	
	/* Setup Property */
	/* Player */
	fprintf(fpout,"PL[B]\n");
	i = 0;
	/* Handicap */
	fprintf(fpout,"HA[%i]",rec_data.Handicap);
	if (rec_data.Handicap) {
		fprintf(fpout,"AB");
		while (i < rec_data.Handicap  ){
			//fprintf(stderr,"%x\n",rec_data.pos[i]);
			fprintf(fpout,"[%c%c]",
				'a'+I_POS(rec_data.pos[i]),'a'+J_POS(rec_data.pos[i]));
			i++;
		}
		fprintf(fpout,"\n");
		/* increment counter */
	}

	/* Game Property */
	//while (rec_data.pos[i]){
	while (i < rec_data.NumberOfTurn + rec_data.Handicap) { 
	if (MODE_POS(rec_data.pos[i]) == BLACK) 
			fprintf(fpout,";B");
		else
			fprintf(fpout,";W");
		
		fprintf(fpout,"[%c%c]\n",
			'a'+I_POS(rec_data.pos[i]),'a'+J_POS(rec_data.pos[i]));
		
		/* increment counter */
		i++;
	}


	/* */
	fprintf(fpout,")");
	
	/* end of root */
	fprintf(fpout,")");
	
	fclose (fpout);
	
	return TRUE;
}

/********************************************************/
/* endian converter */
void ToLittleEndian(STOREDATA *rec_dat)
{
	int i;
	ToLE_Sub((void *)&(rec_dat->Size),sizeof(short));
	ToLE_Sub((void *)&(rec_dat->Version),sizeof(short));
	ToLE_Sub((void *)&(rec_dat->Handicap),sizeof(short));
	ToLE_Sub((void *)&(rec_dat->Time),sizeof(short));
	ToLE_Sub((void *)&(rec_dat->NumberOfTurn),sizeof(short));

	for (i=0;i<BUFF_SIZE_POS;i++)
		ToLE_Sub((void *)&(rec_dat->pos[i]),sizeof(short));

	return ;
}

/********************************************************/
/* endian convertor sub function */
int ToLE_Sub(void *ptr, int size)
{
	unsigned char buf;
	unsigned char *ptr1,*ptr2;

	ptr1 = (char *) ptr;
	ptr2 = (char *) ((char *)ptr + size -1);
	while (ptr1 < ptr2) {
		buf = *ptr1;
		*ptr1 = *ptr2;
		*ptr2 = buf;
		ptr1 ++ ; ptr2 --;
	}
	
	return TRUE;
}







