/*
$Header: /home/koba/pilot/PilotGoJ/src/RCS/main.c,v 1.8 2000/08/17 12:11:45 koba Exp $
*/
/*		Japanized Pilot GO 
		Version 0.40a0
			by koba (BYH10475@nifty.ne.jp)
		based on Pilot Go 0.31 by Dr. Matthias von Davier 
*/
/*
                     Pilot GO frame program
                Version 0.22 last revised 9-17-97

               adapted for the USR Pilot & PalmPilot
                  9/10/97 by Matthias von Davier
*/

/*

                 GNUGO - the game of Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber


		    This program is free software; you can redistribute it and/or modify
		    it under the terms of the GNU General Public License as published by
		    the Free Software Foundation - version 2.

		    This program is distributed in the hope that it will be useful,
		    but WITHOUT ANY WARRANTY; without even the implied warranty of
		    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
		    GNU General Public License in file COPYING for more details.

		    You should have received a copy of the GNU General Public License
		    along with this program; if not, write to the Free Software
		    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

		    Please report any bug/fix, modification, suggestion to

		    manli@cs.uh.edu

*/

/* SEND MODIFICATIONS of the PILOT version to:
 *
 *         vdavier@ipn.uni-kiel.de
 *
 *
 * Pilot Go
 *
 * by Matthias von Davier
 * september 1997
 */

/*
	Pilot Go J
		By Atsushi Kobayashi (BYH10475@nifty.ne.jp)

	Please send modification, bug/fix or comments to me.
*/

#include <PalmOS.h>

/*
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <Preferences.h>
*/

#include "pigoid.h"
#include "pigoty.h"
#include "callback.h"


unsigned char ma[19][19]; /* working matrix for marking */
unsigned char ml[19][19]; /* working matrix for marking */
int lib;                  /* current stone liberty */
int i,j;

int offset, width;
int prefStatus;

GAME game;

char EndMess1[40] = "";
char EndMess2[40] = "";
char buff[5] = "00000";

int penX, penY, dummy;
int moved;
int keyCnt;
char chr_x,chr_y;



void SaveStatus(void);
int SaveNewRecord(void);

Boolean PilotGoMainEvent(EventPtr event);
Boolean PilotGoPrefsEvent(EventPtr event);
Boolean PilotGoInfo1Event(EventPtr event);
Boolean PilotGoInfo2Event(EventPtr event);

void SetSaveData(void);
static void SubNewGame(void) ;
static void SubAskFillNeutral(void) ;
static void SubShowInfo(void) ;
static void SubEndGame0(void) ;
static void SubEndGame(void) ;
static void SubKeyInput(char);
static void SubPlay(void);
static void SubUndo(void);

static void Swap(int *i, int *j);

static Boolean HumanMove(int penX, int penY);
static void KnightMoves(void);
static void RemoveDeadPiece(int i, int j ,unsigned char color );
static void StoneHenge(int penX, int penY, int MoveColor, int OtherColor);
static void SetHandicap(void);

void DrawPiece(int x, int y, unsigned char color, Boolean last);

#define	 PGOJ_SndPlaySystemSound(mode) \
	 { if (game.SndEnable) SndPlaySystemSound(sndError); }



/********************************************************************/
static void Swap(int *i, int *j)
{
	int temp;
	temp = *i;
	*i = *j;
	*j = temp;
}

/********************************************************************/
void Newgame(void)
{ 
	int i;
	int j;

	for (i=0;i<game.BoardSize; i++)
	{
		for(j=0;j<game.BoardSize; j++)
		{
			game.p[i][j] = EMPTY;
			game.undo[i][j] = EMPTY;
		}
	}

	/* init global variables */
	game.mk = 0;  
	game.uk = 0;
	/* init global variables */
	game.play = PLAY;
	game.pass = 0;
	game.mik = -1; 
	game.mjk = -1;
	game.uik = -1; 
	game.ujk = -1;
	game.lastX = -1; 
	game.lastY = -1;
	game.mycount = 0;
	game.undocnt = 0;
	game.uk_undo[0] =game.uk_undo[1] 
		= game.uk_undo[2] = game.uk_undo[3]=0;
	game.mk_undo[0] =game.mk_undo[1]
		= game.mk_undo[2] = game.mk_undo[3]=0;

	game.opn[4] = 0;
	game.opn[0] = game.opn[1] = game.opn[2] = game.opn[3] =
		game.opn[5] = game.opn[6] =	game.opn[7] = game.opn[8] = 1;
	keyCnt = 0;
 
	return;
}


/**********************************************************/
/* */
void SetSaveData(void)
{	
	/* for SGF */
	game.data.Size = game.BoardSize;
	game.Version = PREFVERSION;
	{
		UInt32 secs;
		DateType date;

		secs = TimGetSeconds();
		DateSecondsToDate(secs, &date);
		StrPrintF(game.data.Date,
			  "%04i-%02i-%02i",date.year+1904,date.month,date.day);
	}

	/* Version */
	StrCopy(game.data.PGOJVersion,PGOJVERSION);

	/* Event */
	StrCopy(game.data.Event,"Event");
	StrCopy(game.data.Round,"Round");
	StrCopy(game.data.Place,"Place");
	StrCopy(game.data.GameName,"GameName");
	StrCopy(game.data.Opening,"Opening");
	StrCopy(game.data.GameComment,"Comment");
	StrCopy(game.data.User,"User");
	StrCopy(game.data.Annotation,"Annotation");
	StrCopy(game.data.Copyright,"koba");
	StrCopy(game.data.Result,"B");
  
	/* Players */
	StrCopy(game.data.Black.Player,"Black");
	StrCopy(game.data.White.Player,"White");

	StrCopy(game.data.Black.Rank,"None");
	StrCopy(game.data.White.Rank,"None");

	StrCopy(game.data.Black.Team,"Black");
	StrCopy(game.data.White.Team,"White");

	/* */
	StrPrintF(game.data.Komi,"%i.5",(int)(game.Komi/2));
	game.data.Handicap = game.handicap;
	game.data.Time = 0;
	game.data.NumberOfTurn = game.mycount;

	/* */
	game.data.Version = VERSION;


	return;
}

/********************************************************************/
static void StoneHenge(int penX, int penY, int MoveColor, int OtherColor)
{
	if (game.lastX != -1) 
		DrawPiece(game.lastX,game.lastY,
			  game.p[game.lastX][game.lastY],FALSE);

	game.p[penX][penY] = MoveColor;
	examboard(OtherColor);

	/*	*/
	game.data.pos[game.mycount+game.handicap] =
		//game.mycount+game.handicap;
		SET_POS(( (MoveColor==BLACK)?BLACK:WHITE),penX,penY);

	/*	*/
	DrawPiece(penX,penY,MoveColor,TRUE);	
	game.lastX = penX;
	game.lastY = penY;
	game.mycount++;
	

	return;
}

/********************************************************************/
static Boolean check_ko(int i,int j)
{
	if ( (game.BlackWhite != ((HUMAN << 2) | HUMAN)) ||
	     i != game.uik || j != game.ujk) return FALSE;
	return TRUE;
}

/********************************************************************/
/*	Human	*/
static Boolean HumanMove(int penX, int penY)
{
	unsigned char undomask;

	if ((game.p[penX][penY] != EMPTY) || suicide(penX, penY) || check_ko(penX,penY)) {
		FrmCustomAlert(alertID_message,"","Illegal move!","");
		return FALSE;
	} else {
		/*	copy current board to Undo Buffer	*/
		switch (game.undocnt)	{
		case 0: undomask=0xfc; break;
		case 1: undomask=0xf3; break;
		case 2: undomask=0xcf; break;
		case 3: undomask=0x3f; break;
		default: undomask=0x00; break;
		}
	
		for (j=0;j<game.BoardSize;j++) 
			for (i=0;i<game.BoardSize;i++) 
				game.undo[i][j] = (game.undo[i][j]&undomask) |
					((game.p[i][j]&0x03) << (2*game.undocnt)) ;

		game.mycount_undo[game.undocnt] = game.mycount;
		game.lastX_undo[game.undocnt] = game.lastX;
		game.lastY_undo[game.undocnt] = game.lastY;
		game.uk_undo[game.undocnt] = game.uk;
		game.uik_undo[game.undocnt] = game.uik;
		game.ujk_undo[game.undocnt] = game.ujk;
		game.mk_undo[game.undocnt] = game.mk;
		game.mik_undo[game.undocnt] = game.mik;
		game.mjk_undo[game.undocnt] = game.mjk;

		game.undocnt ++; if (game.undocnt>=UNDOMAX) game.undocnt = 0;

		/*		*/
		StoneHenge(penX,penY,game.umove,game.mymove);
		game.pass = 0;
		return TRUE;
	}
}


/********************************************************************/
/*	Computer 	*/
static void KnightMoves(void)
{
	int penX,penY;

	genmove(&penX,&penY);

	if (penX != -1)
		StoneHenge(penX,penY,game.mymove,game.umove);
	else
		if (game.RulePass == TRUE)
			FrmCustomAlert(alertID_message,"","I pass!","");
		else	{
			FrmCustomAlert(alertID_message,"","I want to pass. End Game!","");
			game.pass = 2;
		}

	return;
			
}

/***********************************************/
static void  RemoveDeadPiece(int i, int j ,unsigned char color )
{

	if (game.p[i][j] == game.mymove) game.mk++;
	if (game.p[i][j] == game.umove) game.uk++;

	game.p[i][j] = EMPTY;
	DrawPiece(i,j,EMPTY,FALSE);

	// check i-1
	if (i>=0 && game.p[i-1][j] == color)
		RemoveDeadPiece(i-1,j,color);

	// check i+1
	if (i<game.BoardSize  && game.p[i+1][j] == color)
		RemoveDeadPiece(i+1,j,color);

	// check j-1
	if (j>=0 && game.p[i][j-1] == color)
		RemoveDeadPiece(i,j-1,color);

	// check j+1
	if (j<game.BoardSize && game.p[i][j+1] == color)
		RemoveDeadPiece(i,j+1,color);


	return ;

}


/************************************************/
/*	Event Handler for Main			*/
/************************************************/
Boolean PilotGoMainEvent(EventPtr event)
{
	FormPtr   form;
	int       handled = 0;
	char chr;


	CALLBACK_PROLOGUE

		switch (event->eType)
		{

			/********** O P E N   E V E N T ********/
		case frmOpenEvent:
			form = FrmGetActiveForm();
			FrmDrawForm(form);
			if (prefStatus) SubNewGame();
			ShowBoard();

			handled = 1;
			break;

			/********** P E N   D O W N   E V E N T ********/
		case penDownEvent:
			dummy = (width / 2) - offset;
			penX = (event->screenX + dummy) / width;
			penX = MIN(18,MAX(0,penX));
			penY = (event->screenY + dummy) / width;
			penY = MIN(18,MAX(0,penY));
			if (keyCnt==2) {
				EraseDummyPiece(chr_x,chr_y);
				keyCnt = 0;
			}
			SubPlay();

			handled = TRUE;
			break;

			/***** K E Y   D O W N   E V E N T ******/
		case keyDownEvent:
			chr=event->data.keyDown.chr;
			SubKeyInput(chr);
			
			
			break;
			/********** M E N U   E V E N T ********/
		case menuEvent:
			switch (event->data.menu.itemID)
			{
		       	/*	for Files	*/
			case menuitemID_prefs:
				FrmGotoForm(formID_Prefs);
				break;
				
			case menuitemID_newgame:
				if (FrmCustomAlert(alertID_confirm,
						   "","New Game?","") == 0)
					SubNewGame();
				//ClearScreen();
				ShowBoard();
				handled=1;
				break;

			case menuitemID_loadgame:
			case menuitemID_savegame:
				FrmCustomAlert(alertID_message," ",
					       "Not Yet implemented"," ");
				break;

				/*	for Play	*/
			case menuitemID_undo:
				SubUndo();
				break;

			case menuitemID_pass:
				if(game.play != PLAY) break; 
				if(game.RulePass == FALSE) {
					FrmCustomAlert(alertID_message,"","You can't pass!","");
					break;
				}
				if (FrmCustomAlert(alertID_confirm," ",
						   "Pass move?"," ") == 0) {
					++game.pass;
					if (game.pass<2) {
						if (game.BlackWhite == ((HUMAN<<2)|HUMAN)) {
							/*	Human vs Human	*/
							Swap(&game.mymove, &game.umove);
							Swap(&game.mk, &game.uk);
							Swap(&game.mik, &game.uik);
							Swap(&game.mjk, &game.ujk);
						} else {
							KnightMoves();
						}
					}
				}
				break;

			case menuitemID_end:
				if(game.play==PLAY)
					if (FrmCustomAlert(alertID_confirm," ",
							   "End Game?"," ") == 0)
						game.pass = 2;
				break;

			case menuitemID_continue:
				switch (game.play)
				{
				case ENDGAME:
					break;

				case REMOVEDEAD:
				/* After remove dead pieces, fill in neutral */
					SubAskFillNeutral();
					break;
				case FILLNEUTRAL:
					SubEndGame();
					break;

				}
				break;

				/*	for HELP	*/
			case menuitemID_info:
				SubShowInfo();
				break;

			case menuitemID_help:
				FrmHelp(HelpStr);
				break;

			case menuitemID_about:
				FrmAlert(alertID_about);
				break;

			default:
				break;
			}
		case nilEvent:
			handled = 1;
			break;
		default:
			break;
		}

	/* ENDGAME == TRUE */
	if ((game.pass > 1) && (game.play == PLAY))
		SubEndGame0();

	CALLBACK_EPILOGUE
		
		return handled;
}


/****************************************************/
#define	SET_HANDICAP(hcnt,a,b)	{	\
	game.p[a][b] = BLACK; \
	game.data.pos[game.mycount+hcnt] = \
        SET_POS(BLACK|HANDICAP,a,b); \
	}	

/*******************************************************************************/
static void SetHandicap(void)
{
	int a,b,c;
	switch (game.BoardSize)	{
	case 9: a=2;b=4;c=6;break;
	case 13:a=3;b=6;c=9;break;
	default:a=3;b=9;c=15;break;
	}

	switch (game.handicap)	{
	case 9: SET_HANDICAP(8,c,b);
	case 8: SET_HANDICAP(7,a,b);
	case 7: SET_HANDICAP(6,b,c);
	case 6: SET_HANDICAP(5,b,a);
	case 5: SET_HANDICAP(4,b,b);
	case 4: SET_HANDICAP(3,c,c);
	case 3: SET_HANDICAP(2,a,a);
	case 2: SET_HANDICAP(1,c,a);
	case 1: SET_HANDICAP(0,a,c);
	default:break;
	}
	return;
}


/*******************************************************************************/
static void SubNewGame(void) 
{
	/*	Clear preference	*/
	prefStatus = FALSE;

	/*	Black 	White	*/
	if (game.BlackWhite != ((HUMAN<<2)|HUMAN)){
		/*	Human vs Computer	*/
		if ((game.BlackWhite&0x03) == HUMAN)	{
			game.mymove = WHITE;/* computer white */
			game.umove = BLACK; /* human black */
		} else {
			game.mymove = BLACK;/* computer black */
			game.umove = WHITE; /* human white */
		}
	} else {
		/*	Human vs Human	*/
		game.mymove = WHITE;  /* human white */
		game.umove = BLACK; /* human black */
	}

	Newgame();
	SaveStatus();

	if (game.handicap > 0) SetHandicap();

	/*	if Palm is black	*/
	if (game.mymove == BLACK) KnightMoves();

	return;
}

/*******************************************************************************/
static void SubAskFillNeutral(void) 
{
	if(FrmCustomAlert(alertID_confirm,
			  "Next, you need to fill in pieces (black and white) in all neutral territories. Tap on the intersections ",
			  "and your and my color will be filled in alternately, choose 'Continue' when finished.",
			  "\n\n Are the neutral areas?")==0)
	{
		game.play = FILLNEUTRAL;
		game.fill = BLACK;
		return;
	}
	SubEndGame();	
	return ;
}

/*******************************************************************************/
static void SubEndGame0(void)
{

	// game.play = REMOVEDEAD;
	FrmCustomAlert(alertID_message,
		       "To count score, we need the following steps: First, I need you to remove all ",
		       "dead pieces on the board. Second, I need you to fill in neutral territories ",
		       "with pieces. Last, I will fill in all pieces and announce the winner.");

	/* remove dead pieces */

	game.pass = 0;

	if (FrmCustomAlert(alertID_confirm,
			   "First, you should enter the dead pieces (black and white) to be removed. ",
			   "Choose 'Continue' in the Options menu when finished.\n\n",
			   "Are there dead pieces?")==0) {
		game.play = REMOVEDEAD;
	} else {
		game.play = FILLNEUTRAL;
		SubAskFillNeutral();
	}

}

/*******************************************************************************/
static void SubEndGame(void) 
{	
	int mtot,utot;
	int mme,ume;		/* number of eyes	*/
	int score;
	int BW;

	/* set empty to side they belong to */
	mme=ume=0;
	for (i = 0; i < game.BoardSize; i++)
		for (j = 0; j < game.BoardSize; j++)
			if (game.p[i][j] == EMPTY) {
				if((game.p[i][j] = findcolor(i, j)) == game.mymove)
					mme++;
				else
					ume++;

				DrawPiece(i,j,game.p[i][j],FALSE);
			}

	/*	Scoring Rule	*/
	//	Japanese style  Teritory Rule
	utot = ume - game.uk;
	mtot = mme - game.mk;


	/*	Adding Komi	*/
	if (game.mymove == WHITE) {
		mtot = mtot * 2 + game.Komi;
		utot <<= 1;
	} else {
		mtot <<= 1;
		utot = utot *2 + game.Komi;
	}

	if (game.BlackWhite != ((HUMAN << 2) | HUMAN)) {
		/*	Palm vs Human	*/
		if (utot > mtot) {
			score = utot - mtot;
			StrCopy(EndMess1,"Can't believe it, you win!");
			if (game.umove == WHITE)
				BW =   'W';
			else
				BW =   'B';

		} else {
			score = mtot - utot;
			StrCopy(EndMess1,"I win! (pretty easy)");
			if (game.mymove == WHITE)
				BW =   'W';
			else
				BW =   'B';
		}

	} else {
		/*	Human vs Human	*/
		/*	my:black	*/
		/*	u:white		*/
		if (game.mymove == WHITE)	Swap(&utot,&mtot);

		if (utot > mtot) {
			score = utot - mtot;
			StrCopy(EndMess1,"White wins!");
			BW = 'W';
		} else {
			score = mtot - utot;
			StrCopy(EndMess1,"Black wins!");
			BW = 'B';
		}
	}
	game.data.Result[1] = '+';
	game.data.Result[2] = NULL;

	StrCopy(EndMess2,"\nScore :");
	StrIToA(buff, score/2 );
	StrCat(buff, ".5");
	StrCat(EndMess2, buff);


	/*	Display Score	*/
	FrmCustomAlert(alertID_message,EndMess1, EndMess2,"" );


	/*	Save record	*/
	SetSaveData();
	StrPrintF(game.data.Result,"%c+%s",BW,buff);

	if (SaveNewRecord()) {
		FrmCustomAlert(alertID_message,"","Save New Record NG","");
	}
	return;
}
	
#define ALPHA 0
#define NUMBER 1

/*************************************************************************************/
static void SubKeyInput(char chr)
{
	static int alpha_mode = ALPHA;
	
	//char chr = *pchr;
	//char chr_x = *pchr_x;
	//char chr_y = *pchr_y;

	/*
	  1st set x-position
	  2nd set y-position
	  3rd if space then fixed. or discarded
	  
	  ALPHA mode
	  keyCnt
	  0 x-position
	  1 y-position
	  2 if "LF", settlement

	  NUMBER mode
	  keyCnt
	  0 1st letter of x-positon 
	  1 check 2nd letter of x-position, if space , keyCnt is increased.
	  2 y-position, if space, keyCnt is increased.
	  3 if "LF", settlement
	*/
	switch (keyCnt){
	case 0:
  	       	/* back space */
		if ( chr == 0x08 ){
			SubUndo();
			break;
		}
		/* check key code routine */
		//StrPrintF(EndMess2,"key:%2x  x:%i y:%i",chr,chr_x,chr_y);
		//FrmCustomAlert(alertID_message,"", EndMess2,"" );
		
		// check alphabet or number ? "aa" or "1 1"
		if (chr < 'a') {
			alpha_mode = NUMBER; 
			chr_x = chr - '0';
		} else {
			alpha_mode = ALPHA;
			chr_x = chr - 'a';
			if (chr_x<0 || chr_x >= game.BoardSize ) {
				PGOJ_SndPlaySystemSound(sndError);
				break;
			}
		}		
		chr_y = 0;
		keyCnt++; 
		break;
	default:
		if (alpha_mode == ALPHA) {
			// ALPHABET mode. For example, "aa", "cf", "df", ....
			switch (keyCnt) {
			case 1:		chr_y = chr - 'a';
				if (chr_y<0 || chr_y >= game.BoardSize 
				    || (game.p[(int)chr_x][(int)chr_y] != EMPTY) 
				    || suicide(chr_x, chr_y) 
				    || check_ko(chr_x,chr_y)) {
					PGOJ_SndPlaySystemSound(sndError);
					keyCnt = 0;
				} else {
					DrawDummyPiece(chr_x,chr_y,game.umove);
					keyCnt++;
				}
				break;
			default:
				if (chr == 0x0A) {
					penX = chr_x;
					penY = chr_y;
					SubPlay();
				} else {
					EraseDummyPiece(chr_x,chr_y);
				}
				keyCnt = 0;
				break;
			}
			break;
		}else {
			// NUMBER mode. For example, "11 12", "1 2",.....
			switch (keyCnt) {
			case 1:
				// x-pos
				if (chr>='0' && chr<='9') {
					chr_x = chr_x * 10 + (chr-'0');
					break;
				} else if (chr == ' ') {
					chr_x --;
					if (chr_x <0 || chr_x > game.BoardSize){
						PGOJ_SndPlaySystemSound(sndError);
						keyCnt = 0; break;
					}
					keyCnt = 2;
					PGOJ_SndPlaySystemSound(sndClick);
					chr_y =0;
					break;
				} 
				keyCnt = 0;break;
			case 2:
				// y-pos
				if (chr>='0' && chr<='9') {
					chr_y = chr_y * 10 + (chr-'0');
					break;
				} else if (chr == ' ') {
					chr_y --;
					// check y-pos is in board
					if (chr_y <0 || chr_y > game.BoardSize 
					    || (game.p[(int)chr_x][(int)chr_y] != EMPTY) 
					    || suicide(chr_x, chr_y) 
					    || check_ko(chr_x,chr_y)) {
						PGOJ_SndPlaySystemSound(sndError);
						keyCnt = 0;
					} else {
						DrawDummyPiece(chr_x,chr_y,game.umove);
						PGOJ_SndPlaySystemSound(sndClick);
						keyCnt++;
					}
					break;
				} 
				keyCnt = 0;break;
			default:
				//
				if (chr == 0x0A) {
					penX = chr_x;
					penY = chr_y;
					SubPlay();
				} else {
					EraseDummyPiece(chr_x,chr_y);
				}
				keyCnt = 0;
				break;
			} // switch (keyCnt)
		} // if 
	} // switch (keyCnt)

	return;
}			


/*****************************************************************************/
static void SubPlay(void)
{
	switch (game.play)
	{
	case PLAY:
		//PGOJ_SndPlaySystemSound(sndClick);
		if (game.BlackWhite == ((HUMAN<<2)|HUMAN)) {
     			/*	Human vs Human	*/
			if (HumanMove(penX,penY)) {
				Swap(&game.mymove, &game.umove);
				Swap(&game.mk, &game.uk);
				Swap(&game.mik, &game.uik);
				Swap(&game.mjk, &game.ujk);
				PGOJ_SndPlaySystemSound(sndClick);
			}
		} else {
			if (HumanMove(penX,penY)) {
				PGOJ_SndPlaySystemSound(sndClick);
				KnightMoves();
			}
		}
		break;
	case ENDGAME:
		break;
	case FILLNEUTRAL:
		//PGOJ_SndPlaySystemSound(sndClick);
		if (game.p[penX][penY] == EMPTY) {
			PGOJ_SndPlaySystemSound(sndClick);
			game.p[penX][penY] = game.fill;
			DrawPiece(penX,penY,game.fill,FALSE);
			if (game.fill == BLACK)
				game.fill = WHITE;
			else
				game.fill = BLACK;
		} else {
			FrmCustomAlert(alertID_message,"",
				       "This intersection is not empty!","");
		}
		break;
	case REMOVEDEAD:
		if (game.p[penX][penY] != EMPTY) {
			PGOJ_SndPlaySystemSound(sndClick);
			RemoveDeadPiece(penX,penY,game.p[penX][penY]);
		}
		break;
	}
	keyCnt = 0;
	return;
}


/*****************************************************************************/
static void SubUndo(void)
{
	/*	check play status	*/
	if (game.play != PLAY) return;	

	/*	check undo rule	*/
	if (game.RuleUndo ==FALSE) {
		FrmCustomAlert(alertID_message,"","You can't undo!","");
		return;
	}

	/*	goto previous undocnt	*/
	game.undocnt --; if (game.undocnt<0) game.undocnt = UNDOMAX-1;
	/*	copy previous board	*/
	for (j=0;j<game.BoardSize;j++) 
		for (i=0;i<game.BoardSize;i++) 
			game.p[i][j] =
				(game.undo[i][j] >> (2*game.undocnt)) 
				& 0x03;

	game.mycount = game.mycount_undo[game.undocnt];
	game.lastX = game.lastX_undo[game.undocnt];
	game.lastY = game.lastY_undo[game.undocnt];
	game.uk = game.uk_undo[game.undocnt];
	game.mk = game.mk_undo[game.undocnt];
	game.uik = game.uik_undo[game.undocnt];
	game.mik = game.mik_undo[game.undocnt];
	game.ujk = game.ujk_undo[game.undocnt];
	game.mjk = game.mjk_undo[game.undocnt];

	/*	if Human vs Human	*/
	if (game.BlackWhite == ((HUMAN<<2) | HUMAN)) {
		Swap(&game.mymove, &game.umove);
		Swap(&game.mk, &game.uk);
		Swap(&game.mik, &game.uik);
		Swap(&game.mjk, &game.ujk);
	}
			
			
	/*	Redraw prev board	*/
	//ClearScreen();
	ShowBoard();

	return;
}

/*******************************************************************************/
static void SubShowInfo(void)
{
	/*	show infomation	*/
	/*	number of turn	*/
	/*	vs		*/
	/*	killed count 	*/

	StrCopy(EndMess1,"Turn:");
	StrIToA(buff,game.mycount);
	StrCat(EndMess1, buff);
	
	/*	*/
	if ((game.BlackWhite & 0x03) == HUMAN)
		StrCopy(EndMess2,"\nBlack:Human ");
	else 
		StrCopy(EndMess2,"\nBlack:Palm ");
	
	if (((game.BlackWhite>>2) & 0x03) == HUMAN)
		StrCat(EndMess2,"White:Human");
	else 
		StrCat(EndMess2,"White:Palm");
	
	/*	Captured 	*/

	
	/*	Display Information	*/
	FrmCustomAlert(alertID_message,EndMess1, EndMess2,"" );

	return;
}













