/*
$Header: /home/koba/pilot/PilotGoJ/src/RCS/hugo2.c,v 1.10 2000/08/17 09:59:51 koba Exp $
*/
/*
                 GNUGO - the game of Go (Wei-Chi)
                Version 1.2   last revised 10-31-95
           Copyright (C) Free Software Foundation, Inc.
                      written by Man L. Li
                      modified by Wayne Iba
        modified by Frank Pursel <fpp%minor.UUCP@dragon.com>
                    documented by Bob Webber

                adapted for the USR Pilot & PalmPilot
                9/10/97 by Matthias von Davier

             ( this file does not contain GNUGO funcs
               main, getmove and getij
               as they are not used in the Pilot Version )

*/
/*
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation - version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License in file COPYING for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Please report any bug/fix, modification, suggestion to

           manli@cs.uh.edu

and for the PILOT version:

           vdavier@ipn.uni-kiel.de
*/
/* replace
 * 16 = (game.BoardSize - 3)
 * 17 = (game.BoardSize - 2)
 * 18 = (game.BoardSize - 1)
 * 19 = game.BoardSize
 * mymove = game.mymove DONE
 * umove  = game.umove DONE
 * mk = game.mk DONE
 * uk = game.uk DONE
 * p[ = game.p[ DONE
 * l[ = game.l[ DONE
 * opn[ = game.opn[ DONE
 */


/* hugo3.c Show Go Board on Pilot screen
 * 10.9.1997 MvD
 *
*/

#include <PalmOS.h>

/*
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
*/

#include "pigoid.h"
#include "pigoty.h"

#include "patterns.h"
#include "extvargo.h"

/* int rand(void)
{   return SysRandom(0);
    } */

void DrawPiece(int x, int y, unsigned char color, Boolean last);

/*	for saver	*/
int	lib_offset = 0;
int	val_left,val_right,val_top,val_bottom;

/*-------------------------------------
  count.c -- Count liberty around stone
-------------------------------------*/

void count(int i,     /* row number 0 to 18 */
	   int j,     /* column number 0 to 18 */
	   int color) /* BLACK or WHITE */
/* count liberty of color piece at location i, j
   and return value in lib */
{
	/* set current piece as marked */
	ml[i][j] = EMPTY;

	/* check North neighbor */
	if (i != EMPTY)
	{
		if ((game.p[i - 1][j] == EMPTY) && ml[i - 1][j])
		{
			++lib;
			ml[i - 1][j] = EMPTY;
		}
		else
			if ((game.p[i - 1][j] == color) && ml[i - 1][j])
				count(i - 1, j, color);
	}
	/* check South neighbor */
	if (i != (game.BoardSize-1))
	{
		if ((game.p[i + 1][j] == EMPTY) && ml[i + 1][j])
		{
			++lib;
			ml[i + 1][j] = EMPTY;
		}
		else
			if ((game.p[i + 1][j] == color) && ml[i + 1][j])
				count(i + 1, j, color);
	}
	/* check West neighbor */
	if (j != EMPTY)
	{
		if ((game.p[i][j - 1] == EMPTY) && ml[i][j - 1])
		{
			++lib;
			ml[i][j - 1] = EMPTY;
		}
		else
			if ((game.p[i][j - 1] == color) && ml[i][j - 1])
				count(i, j - 1, color);
	}
	/* check East neighbor */
	if (j != (game.BoardSize-1))
	{
		if ((game.p[i][j + 1] == EMPTY) && ml[i][j + 1])
		{
			++lib;
			ml[i][j + 1] = EMPTY;
		}
		else
			if ((game.p[i][j + 1] == color) && ml[i][j + 1])
				count(i, j + 1, color);
	}
}  /* end count */


/*--------------------------------------------
  countlib.c -- Count liberty for single stone
--------------------------------------------*/

void countlib(int m,     /* row number 0 to 18 */
	      int n,     /* column number 0 to 18 */
	      int color) /* BLACK or WHITE */
/* count liberty of color piece at m, n */
{
	int i, j;

	/* set all piece as unmarked */
	for (i = 0; i < (game.BoardSize); i++)
		for (j = 0; j < (game.BoardSize); j++)
			ml[i][j] = 1;

	/* count liberty of current piece */
	count(m, n, color);
}  /* end countlib */


/*------------------------------------------------------
  eval.c -- Evaluate liberty of stones in the same color
------------------------------------------------------*/


void eval(int color)  /* BLACK or WHITE */
/* evaluate liberty of color pieces */
{
	int i, j;

	/* find liberty of each piece */
	for (i = 0; i < (game.BoardSize); i++)
		for (j = 0; j < (game.BoardSize); j++)
			if (game.p[i][j] == color)
			{
				lib = 0;
				countlib(i, j, color);
				game.l[i][j] = lib;
			}
	count_string();

}  /* end eval */


/*--------------------------------------------------------------------
  exambord.c -- Examine board liberty for one color and update results
--------------------------------------------------------------------*/

void examboard(int color) /* BLACK or WHITE */
/* examine pieces */
{
	int i, j, n;

	/* find liberty of each piece */
	eval(color);

	/* initialize piece captured */
	if (color == game.mymove)
	{
		game.mik = -1;
		game.mjk = -1;
	}
	else
	{
		game.uik = -1;
		game.ujk = -1;
	}
	n = 0; /* The number of captures this move for Ko purposes */

	/* remove all piece of zero liberty */
	for (i = 0; i < (game.BoardSize); i++)
		for (j = 0; j < (game.BoardSize); j++)
			if ((game.p[i][j] == color) && (game.l[i][j] == 0))
			{
				game.p[i][j] = EMPTY;
				DrawPiece(i,j,EMPTY,FALSE);
				/* record piece captured */
				if (color == game.mymove)
				{
					game.mik = i;
					game.mjk = j;
					++game.mk;
				}
				else
				{
					game.uik = i;
					game.ujk = j;
					++game.uk;
				}
				++n;  /* increment number of captures on this move */
			}
	/* reset to -1 if more than one stone captured since  no Ko possible */
	if (color == game.mymove && n > 1)
	{
		game.mik = -1;
		game.mjk = -1;
	}
	else if ( n > 1 )
	{
		game.uik = -1;
		game.ujk = -1;
	}
}  /* end examboard */

/*------------------------------------------
  findcolr.c -- Find color of empty location
------------------------------------------*/

unsigned int findcolor(int i,   /* row number 0 to 18 */
		       int j)   /* column number 0 to 18 */
/* find color for empty piece */
{
	int k, result, color[4];

	/*
	 * return color if all four neighbors are the same or empty
	 */
	result = EMPTY;

	if (game.p[i][j] != EMPTY) return game.p[i][j];


	/* check North neighbor */
	if (i>0) {  /* The if prevents reading off edge of board. */
		k = i;
		do 
			--k;
		while ((game.p[k][j] == EMPTY) && (k > 0));
		color[0] = game.p[k][j];
	}
	else color[0] = game.p[i][j];

	/* check South neighbor */

	if (i<(game.BoardSize-1)) {
		k = i;
		do 
			++k;
		while ((game.p[k][j] == EMPTY) && (k < (game.BoardSize-1)));
		color[1] = game.p[k][j];
	}
	else color[1] = game.p[i][j];

	/* check West neighbor */
	if (j>0) {
		k = j;
		do 
			--k;
		while ((game.p[i][k] == EMPTY) && (k > 0));
		color[2] = game.p[i][k];
	}
	else color[2] = game.p[i][j];

	/* check East neighbor */
	if (j<(game.BoardSize-1)) {
		k = j;
		do 
			++k;
		while ((game.p[i][k] == EMPTY) && (k < (game.BoardSize-1)));
		color[3] = game.p[i][k];
	}
	else color[3] = game.p[i][j];

	/* Any nonEMPTY color is what we want */

	for (k=0;k<4;k++) {
		if (color[k] == EMPTY) continue;
		else {
			result = color[k];
			break;
		}
	}

	/* We know the right color.  Now cross check it.*/
	/* If we find an error then all the dead pieces were not taken 
	   from the board and we need to prompt the players to fix this. */

	for (k=0;k<4;k++) {
		/* If this next test fails, results are inconsistent.  Problem. */
		if ((color[k] != EMPTY) && (color[k] != result)) return 0;
	}

	/* If we get to this point everything checks out OK.  Report results. */

	return result;
}  /* end findcolor */


/*-------------------------------------------------------
  findopen.c -- Find possible moves from current location
-------------------------------------------------------*/

int findopen(int m,      /* current row number 0 to 18 */
	     int n,      /* current column number 0 to 18 */
	     int i[],    /* row array for possible moves */
	     int j[],    /* column array for possible moves */
	     int color,  /* BLACK or WHITE */
	     int minlib, /* current liberty */
	     int *ct)    /* number of possible moves */
/* find all open spaces i, j from m, n */
{
	/* mark this one */
	ma[m][n] = 1;

	/* check North neighbor */
	if (m != 0)
	{
		if ((game.p[m - 1][n] == EMPTY) && (((m - 1) != game.mik) || (n != game.mjk)))
		{
			i[*ct] = m - 1;
			j[*ct] = n;
			++*ct;
			if (*ct == minlib) return 1;
		}
		else
			if ((game.p[m - 1][n] == color) && !ma[m - 1][n])
				if (findopen(m - 1, n, i, j, color, minlib, ct) && (*ct == minlib))
					return 1;
	}

	/* check South neighbor */
	if (m != (game.BoardSize-1))
	{
		if ((game.p[m + 1][n] == EMPTY) && (((m + 1) != game.mik) || (n != game.mjk)))
		{
			i[*ct] = m + 1;
			j[*ct] = n;
			++*ct;
			if (*ct == minlib) return 1;
		}
		else
			if ((game.p[m + 1][n] == color) && !ma[m + 1][n])
				if (findopen(m + 1, n, i, j, color, minlib, ct) && (*ct == minlib))
					return 1;
	}

	/* check West neighbor */
	if (n != 0)
	{
		if ((game.p[m][n - 1] == EMPTY) && ((m != game.mik) || ((n - 1) != game.mjk)))
		{
			i[*ct] = m;
			j[*ct] = n - 1;
			++*ct;
			if (*ct == minlib) return 1;
		}
		else
			if ((game.p[m][n - 1] == color) && !ma[m][n - 1])
				if (findopen(m, n - 1, i, j, color, minlib, ct) && (*ct == minlib))
					return 1;
	}

	/* check East neighbor */
	if (n != (game.BoardSize-1))
	{
		if ((game.p[m][n + 1] == EMPTY) && ((m != game.mik) || ((n + 1) != game.mjk)))
		{
			i[*ct] = m;
			j[*ct] = n + 1;
			++*ct;
			if (*ct == minlib) return 1;
		}
		else
			if ((game.p[m][n + 1] == color) && !ma[m][n + 1])
				if (findopen(m, n + 1, i, j, color, minlib, ct) && (*ct == minlib))
					return 1;
	}

	/* fail to find open space */
	return 0;
}  /* end findopen */

/*----------------------------------------------------------------
  findpatn.c -- Find computer move from opening moves and patterns
----------------------------------------------------------------*/

int findpatn(int *i,    /* row number of next move */
	     int *j,    /* column number of next move */
	     int *val)  /* value of next move */
/* find pattern to match for next move */
{
	int m, n;
	int ti, tj, tval;
	static int cnd, mtype;  /* game tree node number, move type */
	/* mtype = 0, basic; 1, inverted; 2, reflected; 3, inverted & reflected */

	int mnmax = game.BoardSize-1;
	int mnmid = (game.BoardSize - 1)/2;

	/* open game then occupy corners */
	if (game.opn[4])   /* continue last move */
	{
		game.opn[4] = 0;  /* clear flag */
		if (opening(i, j, &cnd, mtype)) game.opn[4] = 1; /* more move then reset flag */
		if (game.p[*i][*j] == EMPTY)  /* valid move */
		{
			*val = 80;
			return 1;
		}
		else
			game.opn[4] = 0;
	}

	if (game.opn[0])   /* Northwest corner */
	{
		game.opn[0] = 0;  /* clear flag */
		if (openregion(0, 0, 5, 5))
		{
			cnd = 0;
			mtype = 0;
			opening(i, j, &cnd, mtype);  /* get new node for next move */
			if (opening(i, j, &cnd, mtype)) game.opn[4] = 1;
			*val = 80;
			return 1;

		}
	}

	if (game.opn[1])   /* Southwest corner */
	{
		game.opn[1] = 0;
		if (openregion(mnmax-5, 0, mnmax, 5))
		{
			cnd = 0;
			mtype = 1;
			opening(i, j, &cnd, mtype);  /* get new node for next move */
			if (opening(i, j, &cnd, mtype)) game.opn[4] = 1;
			*val = 80;
			return 1;
		}
	}

	if (game.opn[2])   /* Northeast corner */
	{
		game.opn[2] = 0;
		if (openregion(0, mnmax-5, 5, mnmax))
		{
			cnd = 0;
			mtype = 2;
			opening(i, j, &cnd, mtype);  /* get new node for next move */
			if (opening(i, j, &cnd, mtype)) game.opn[4] = 1;
			*val = 80;
			return 1;
		}
	}

	if (game.opn[3])   /* Southeast corner */
	{
		game.opn[3] = 0;
		if (openregion(mnmax-5,mnmax-5,mnmax,mnmax))
		{
			cnd = 0;
			mtype = 3;
			opening(i, j, &cnd, mtype);  /* get new node for next move */
			if (opening(i, j, &cnd, mtype)) game.opn[4] = 1;
			*val = 80;
			return 1;
		}
	}

	/* occupy edges */
	if (game.opn[5])   /* North edge */
	{
		game.opn[5] = 0;
		if (openregion(0, mnmid - 3, 4, mnmid + 3))
		{
			*i = 3;
			*j = mnmid;
			*val = 80;
			return 1;
		}
	}

	if (game.opn[6])   /* South edge */
	{
		game.opn[6] = 0;
		if (openregion(mnmax, mnmid -3, mnmax-4, mnmid + 3))
		{
			*i = (game.BoardSize-4);
			*j = mnmid;
			*val = 80;
			return 1;
		}
	}

	if (game.opn[7])   /* West edge */
	{
		game.opn[7] = 0;
		if (openregion(mnmid - 3, 0, mnmid + 3, 4))
		{
			*i = mnmid;
			*j = 3;
			*val = 80;
			return 1;
		}
	}

	if (game.opn[8])   /* East edge */
	{
		game.opn[8] = 0;
		if (openregion(mnmid - 3, mnmax, mnmid + 3, mnmax-4))
		{
			*i = mnmid;
			*j = (game.BoardSize-4);
			*val = 80;
			return 1;
		}
	}

	*i = -1;
	*j = -1;
	*val = -1;

	/* find local pattern */
	for (m = 0; m < (game.BoardSize); m++)
		for (n = 0; n < (game.BoardSize); n++)
			if ((game.p[m][n] == game.mymove) &&
			    (matchpat(m, n, &ti, &tj, &tval) && (tval > *val)))
			{
				*val = tval;
				*i = ti;
				*j = tj;
			}
	if (*val > 0)  /* pattern found */
		return 1;
	else /* no match found */
		return 0;
}  /* end findpatn */

/*------------------------------------------------------------------
  findsaver.c -- Find computer next move to defend stones from attack
------------------------------------------------------------------*/

int findsaver(int *i,    /* row number of next move */
	      int *j,    /* column number of next move */
	      int *val)  /* value of next move */
/* find move if any pieces is threaten */
{
	int m, n, minlib;
	int ti, tj, tval;

	*i = -1;   
	*j = -1;	 
	*val = -1;
	for (minlib = 1; minlib < 4; minlib++)
	{
		/* count piece with minimum liberty */
		for (m = 0; m < (game.BoardSize); m++)
			for (n = 0; n < (game.BoardSize); n++)
				if ((game.p[m][n] == game.mymove) && (game.l[m][n] == minlib))
				/* find move to save pieces */
				{
					initmark();
					if (findnextsave(m,n,&ti,&tj,&tval,minlib) ) {
						if (tval > *val)	{
							/* code folded from here */
							*val = tval;
							*i = ti;
							*j = tj;
							/* unfolding */
						}
					}
				}
	}
	if (*val > 0)   /* find move */
		return 1;
	else	/* move not found */
		return 0;
}  /* findsaver */


/*---------------------------------------------------------------
  findwinr.c -- Find computer next move to attack opponent stones
---------------------------------------------------------------*/

int findwinner(int *i,    /* row number of next move */
	       int *j,    /* column number of next move */
	       int *val)  /* value of next move */
/* find opponent piece to capture or attack */
{
	int m, n, ti[3], tj[3], tval, ct, u, v, lib1;

	*i = -1;   
	*j = -1;   
	*val = -1;

	/* find opponent with liberty less than four */
	for (m = 0; m < (game.BoardSize); m++)
		for (n = 0; n < (game.BoardSize); n++)
			if ((game.p[m][n] == game.umove) && (game.l[m][n] < 4))
			{
				ct = 0;
				initmark();
				if (findopen(m, n, ti, tj, game.umove, game.l[m][n], &ct))
				{
					if (game.l[m][n] == 1)
					{
						if (*val < 120)
						{
							*val = 120;
							*i = ti[0];
							*j = tj[0];
						}
					}
					else
						for (u = 0; u < (int)game.l[m][n]; u++)
							for (v = 0; v < (int)game.l[m][n]; v++)
								if (u != v) {
/* code folded from here */
									lib = 0;
									countlib(ti[u], tj[u], game.mymove);
									if (lib > 0) /* valid move */
									{
										lib1 = lib;
										game.p[ti[u]][tj[u]] = game.mymove;
										/* look ahead opponent move */
										lib = 0;
										countlib(ti[v], tj[v], game.umove);
										if ((lib1 == 1) && (lib > 0))
											tval = 0;
										else
											tval = 120 - 20 * lib;
										if (*val < tval)
										{
											*val = tval;
											*i = ti[u];
											*j = tj[u];
										}
										game.p[ti[u]][tj[u]] = EMPTY;
									}
/* unfolding */
								}
				}
			}
	if (*val > 0)	/* find move */
		return 1;
	else /* fail to find winner */
		return 0;
}  /* end findwinner */



/*----------------------------------------
  genmove.c -- Generate computer next move
----------------------------------------*/

#define MAXTRY 400

void genmove(int *i,
	     int *j)
/* generate computer move */
{
	int ti, tj, tval;
	char a;
	int ii,  val;
	int try = 0;   /* number of try */

	/* initialize move and value */
	*i = -1;  
	*j = -1;  
	val = -1;


	/* re-evaluate liberty of opponent pieces */
	eval(game.umove);

	/* find opponent piece to capture or attack */
	if (findwinner(&ti, &tj, &tval))
		if (tval > val)
		{
			val = tval;
			*i = ti;
			*j = tj;
		}

	/* save any piece if threaten */
	/* by koba 	*/
	switch ((game.mycount>>1) & 0x0003)	{
	case 0: 
		val_left=0;
		val_right = 1;
		val_top=2; 
		val_bottom = 3;
		break;
	case 1: 
		val_left=1;
		val_right = 2;
		val_top=3; 
		val_bottom = 0;
		break;
	case 2: 
		val_left=2;
		val_right = 3;
		val_top=0; 
		val_bottom = 1;
		break;
	case 3: 
		val_left=3;
		val_right = 0;
		val_top=1; 
		val_bottom = 2;
		break;
	}
	/*	*/
	if (game.mycount < game.BoardSize * 2)
		/*	joban	*/
		lib_offset = 0;
	else
		/* tyuban or syuuban	*/
		lib_offset = 1;


	if (findsaver(&ti, &tj, &tval))
		if (tval > val)
		{
			val = tval;
			*i = ti;
			*j = tj;
		}

	/* try match local play pattern for new move */
	if (findpatn(&ti, &tj, &tval))
		if (tval > val)
		{
			val = tval;
			*i = ti;
			*j = tj;
		}

	/* no urgent move then do random move */
	if (val < 0)
		do {
			*i = rand() % (game.BoardSize);

			/* avoid low line  and center region */
			if ((*i < 2) || (*i > (game.BoardSize-3)) || ((*i > 5) && (*i < 13)))
			{
				*i = rand() % (game.BoardSize);
				if ((*i < 2) || (*i > (game.BoardSize-3)))
					*i = rand() % (game.BoardSize);
			}

			*j = rand() % (game.BoardSize);

			/* avoid low line and center region */
			if ((*j < 2) || (*j > (game.BoardSize-3)) || ((*j > 5) && (*j < 13)))
			{
				*j = rand() % (game.BoardSize);

				if ((*j < 2) || (*j > (game.BoardSize-3)))
					*j = rand() % (game.BoardSize);

			}
			lib = 0;
			countlib(*i, *j, game.mymove);
		}/* avoid illegal move, liberty one or suicide, fill in own eye */
		while ((++try < MAXTRY)
		       && ((game.p[*i][*j] != EMPTY) || (lib < 2) || check_eye(*i,*j,game.mymove)));

	if (try >= MAXTRY)  /* computer pass */
	{
		game.pass++;
		// printf("I pass.\n");
		// HIER AENDERN
		*i = -1;
	}
	else /* find valid move */
	{
		game.pass = 0;
		// HIER AENDERN
		// printf("my move: ");
		if (*j < 8)
			a = *j + 65;
		else
			a = *j + 66;
		// printf("%c", a);
		ii = (game.BoardSize) - *i;
		// HIER AENDERN
		//  if (ii < 10)
		// printf("%1d\n", ii);
		//  else
		// printf("%2d\n", ii);
	}
}  /* end genmove */

/*----------------------------------------
  initmark.c -- initialize working matrix
----------------------------------------*/

void initmark(void)
/* initialize all marking with zero */
{
	int i, j;

	for (i = 0; i < (game.BoardSize); i++)
		for (j = 0; j < (game.BoardSize); j++)
			ma[i][j] = 0;
}  /* end initmark */

/*-----------------------------------
  matchpat.c -- Match pattern moves
-----------------------------------*/


#define abs(x) ((x) < 0 ? -(x) : (x))
#define line(x) (abs(x - 9))

int matchpat(int m,     /* row origin */
	     int n,     /* column origin */
	     int *i,    /* row number of next move */
	     int *j,    /* column number of next move */
	     int *val)  /* next move value */
/* match pattern and get next move */
{
	/* transformation matrice */
	static int trf [8][2][2] = {
		{{1, 0}, {0, 1}},   /* linear transfomation matrix */
		{{1, 0}, {0, -1}},  /* invert */
		{{0, 1}, {-1, 0}},  /* rotate 90 */
		{{0, -1}, {-1, 0}}, /* rotate 90 and invert */
		{{-1, 0}, {0, 1}},  /* flip left */
		{{-1, 0}, {0, -1}}, /* flip left and invert */
		{{0, 1}, {1, 0}},   /* rotate 90 and flip left */
		{{0, -1}, {1, 0}}/* rotate 90, flip left and invert */
	};
	int k, my, nx, ll, r, cont;
	int ti,tj,tval;

	ti = *i = -1;   
	tj = *j =-1;   
	*val = -1;
	for (r = 0; r < PATNO; r++)
		/* try each pattern */
		for (ll = 0; ll < pat[r].trfno; ll++)
			/* try each orientation transformation */
		{
			k = 0;  
			cont = 1;
			while ((k != pat[r].patlen) && cont)
				/* match each point */
			{
				/* transform pattern real coordinate */
				nx = n + trf[ll][0][0] * pat[r].patn[k].x
					+ trf[ll][0][1] * pat[r].patn[k].y;
				my = m + trf[ll][1][0] * pat[r].patn[k].x
					+ trf[ll][1][1] * pat[r].patn[k].y;

				/* outside the board */
				if ((my < 0) || ( my > (game.BoardSize-1)) || (nx < 0) || (nx > (game.BoardSize-1)))
				{
					cont = 0;
					break;
				}
				switch (pat[r].patn[k].att) {
				case 0 : 
					if (game.p[my][nx] == EMPTY)  /* open */
						break;
					else
					{
						cont = 0;
						break;
					}
				case 1 : 
					if (game.p[my][nx] == game.umove)  /* your piece */
						break;
					else
					{
						cont = 0;
						break;
					}
				case 2 : 
					if (game.p[my][nx] == game.mymove)  /* my piece */
						break;
					else
					{
						cont = 0;
						break;
					}
				case 3 : 
					if (game.p[my][nx] == EMPTY)  /* open for new move */
					{
						lib = 0;
						countlib(my, nx, game.mymove);  /* check liberty */
						if (lib > 1)  /* move o.k. */
						{
							ti = my;
							tj = nx;
							break;
						}
						else
						{
							cont = 0;
							break;
						}
					}
					else
					{
						cont = 0;
						break;
					}
				case 4 : 
					if ((game.p[my][nx] == EMPTY)  /* open on edge */
					    && ((my == 0) || (my == (game.BoardSize-1)) || (nx == 0) || (nx == (game.BoardSize-
														1))))
						break;
					else
					{
						cont = 0;
						break;
					}
				case 5 : 
					if ((game.p[my][nx] == game.umove)  /* your piece on edge */
					    && ((my == 0) || (my == (game.BoardSize-1)) || (nx == 0) || (nx == (game.BoardSize-
														1))))
						break;
					else
					{
						cont = 0;
						break;
					}
				case 6 : 
					if ((game.p[my][nx] == game.mymove)  /* my piece on edge */
					    && ((my == 0) || (my == (game.BoardSize-1)) || (nx == 0) || (nx == (game.BoardSize-
														1))))
						break;
					else
					{
						cont = 0;
						break;
					}
				}
				++k;
			}
			if (cont)   /* match pattern */
			{
				tval = pat[r].patwt;
				if ((r >= 8) && (r <= 13))	/* patterns for expand region */
				{
					if (line(ti) > 7)  /* penalty on line 1, 2 */
						tval--;
					else
						if ((line(ti) == 6) || (line(ti) == 7))
							tval++;	/* reward on line 3, 4 */

					if (line(tj) > 7)  /* penalty on line 1, 2 */
						tval--;
					else
						if ((line(tj) == 6) || (line(tj) == 7))
							tval++;	/* reward on line 3, 4 */
				}
				if (tval > *val)
				{
					*val = tval;
					*i = ti;
					*j = tj;
				}
			}
		}
	if (*val > 0)	/* pattern matched */
		return 1;
	else /* match failed */
		return 0;
}  /* end matchpat */

/*-----------------------------------
  opening.c -- Select opening moves
-----------------------------------*/

/*#include <stdlib.h>*/

int opening(int *i,
	    int *j,
	    int *cnd,
	    int type)
/* get move for opening from game tree */
{
	struct tnode {
		int i, j, ndct, next[8];
	};

	static struct tnode tree[] = {
		{-1, -1, 8, { 1, 2, 3, 4, 5, 6, 7, 20}},	/* 0 */
		{2, 3, 2, { 8, 9}},
		{2, 4, 1, {10}},
		{3, 2, 2, {11, 12}},
		{3, 3, 6, {14, 15, 16, 17, 18, 19}},
		{3, 4, 1, {10}},  /* 5 */
		{4, 2, 1, {13}},
		{4, 3, 1, {13}},
		{4, 2, 0},
		{4, 3, 0},
		{3, 2, 0},  /* 10 */
		{2, 4, 0},
		{3, 4, 0},
		{2, 3, 0},
		{2, 5, 1, {10}},
		{2, 6, 1, {10}},  /* 15 */
		{3, 5, 1, {10}},
		{5, 2, 1, {13}},
		{5, 3, 1, {13}},
		{6, 2, 1, {13}},
		{2, 2, 0}/* 20 */
	};
	int m;

	/* get i, j */
	if ((type == 1) || (type == 3))
		*i = (game.BoardSize-1) - tree[*cnd].i;   /* inverted */
	else
		*i = tree[*cnd].i;
	if ((type == 2) || (type == 3))
		*j = (game.BoardSize-1) - tree[*cnd].j;   /* reflected */
	else
		*j = tree[*cnd].j;
	if (tree[*cnd].ndct)  /* more move */
	{
		m = rand() % tree[*cnd].ndct;  /* select move */
		*cnd = tree[*cnd].next[m];	/* new	current node */
		return 1;
	}
	else
		return 0;
}  /* end opening */

/*--------------------------------------------------
  openregn.c -- Check if rectangular region is open
---------------------------------------------------*/

int openregion(int i1,
	       int j1,
	       int i2,
	       int j2)
/* check if region from i1, j1 to i2, j2 is open */
{
	int minx, maxx, miny, maxy, x, y;

	/* exchange upper and lower limits */

	if (i1 < i2)
	{
		miny = i1;
		maxy = i2;
	}
	else
	{
		miny = i2;
		maxy = i1;
	}

	if (j1 < j2)
	{
		minx = j1;
		maxx = j2;
	}
	else
	{
		minx = j2;
		maxx = j1;
	}

	/* check for empty region */
	for (y = miny; y <= maxy; y++)
		for (x = minx; x <= maxx; x++)
			if (game.p[y][x] != EMPTY) return 0;
	return 1;
}  /* end openregion */



/*----------------------------------------------
  suicide.c -- Check for opponent illegal move
----------------------------------------------*/

int suicide(int i,
	    int j)
/* check for suicide move of opponent at game.p[i][j] */
{
	int m, n, k;
	unsigned char predata;

	predata = game.p[i][j];

	/* check liberty of new move */
	lib = 0;
	countlib(i, j, game.umove);
	if (lib == 0)
		/* new move is suicide then check if kill my pieces and Ko possibility */
	{
		/* assume alive */
		game.p[i][j] = game.umove;

		/* check my pieces */
		eval(game.mymove);
		k = 0;

		for (m = 0; m < (game.BoardSize); m++)
			for (n = 0; n < (game.BoardSize); n++)
				/* count pieces will be killed */
				if ((game.p[m][n] == game.mymove) && !game.l[m][n]) ++k;

		game.p[i][j] = predata;

		if ((k == 0) || (k == 1 && ((i == game.uik) && (j == game.ujk))))
				/* either no effect on my pieces or an illegal Ko take back */
		{
			/* restore to open */
			return 1;
		}
	}

	/* valid move */
	return 0;

}  /* end suicide */



/*******************************/


/*------------------------------------------------------
	eval.c -- Evaluate liberty of stones in the same color
------------------------------------------------------*/


/**********************************************************/
int	check_newmove(int new_m,int new_n,int minlib,int val_option)
{
	int val;

	/* check suicide	*/
	/* temporay move	*/
	game.p[new_m][new_n] = game.mymove;
	lib = 0;
	countlib(new_m, new_n, game.mymove);
	game.p[new_m][new_n] = EMPTY;

	val = (40 + 
	       game.ng[new_m][new_n] * (lib - minlib-lib_offset) * 30 / (minlib * minlib * minlib))
		- val_option;

	switch (lib)	{
	case 0: 
		return -1;	/* suicide */
	case 1: 
		return (val-1)/2; /* probably suicide*/
	default: 
		; 
		break;
	}

	if (check_eye(new_m,new_n,game.mymove) ) return -1;
	return val;

}

/**********************************************************/
int findnextsave(int m,		/* current stone row number */
		 int n,		/* current stone column number */
		 int *i,		/* next move row number */
		 int *j,		/* next move column number */
		 int *val,	/* next move value */
		 int minlib)	/* current stone liberty */
/* find new move i, j from string containing m, n */
{
	int /*ti, tj,*/ tval;
	/*int found = 0;*/

	*i = -1;	
	*j = -1;	
	*val = -1;

	if (game.l[m][n] >= minlib)	{

		/*	check left	*/
		if (m > 0 && game.p[m-1][n] == EMPTY)	{
			tval = check_newmove(m-1,n,minlib, val_left);
			if (tval > *val) {
				*val = tval; 
				*i = m-1;
				*j = n;
			}
		}
		/*	check right	*/
		if (m <game.BoardSize - 1 && game.p[m+1][n] == EMPTY)	{
			tval = check_newmove(m+1,n,minlib,val_right);
			if (tval > *val) {
				*val = tval; 
				*i = m+1;
				*j = n;
			}
		}
		/*	check bottom	*/
		if (n > 0 && game.p[m][n-1] == EMPTY)	{
			tval = check_newmove(m,n-1,minlib, val_bottom);
			if (tval > *val) {
				*val = tval;
				*i = m;
				*j = n - 1;
			}
		}
		/*	check top	*/
		if (n < game.BoardSize - 1 && game.p[m][n+1] == EMPTY)	{
			tval = check_newmove(m,n+1,minlib,val_top);
			if (tval > *val) {
				*val = tval;
				*i = m;
				*j = n + 1;
			}
		}
	}



	if (*val > 0){	/* found next move */
		return 1;
	}
	else	/* next move failed */
		return 0;
}	/* end findnextmove */



/**********************************************/
static int	count_string1(int m, int n,int color );
static void	count_string2(int m, int n,int color ,int ng0);

int	count_string(void)
/*	count the number of string which includes (m,n)
*/
{
	int i,j;

	initmark();
	for (i=0;i<game.BoardSize;i++) {
		for (j=0;j<game.BoardSize;j++)	{
			if (ma[i][j] == EMPTY && game.p[i][j] != EMPTY) {
				count_string2(i,j,game.p[i][j],count_string1(i,j,game.p[i][j]) );
				/*printf("%i %c p:%i\n",game.BoardSize - i,'A'+j,game.p[i][j]);*/
			}
		}
	}

	return 0;
}

/******************************************************/
static int	count_string1(int m, int n,int color )
{
	int cnt = 1;

	ma[m][n] = color;

	/*	check left */
	if (m < game.BoardSize-1 && game.p[m+1][n] == color && ma[m+1][n] == EMPTY) {
		cnt += count_string1(m+1,n,color) ;
	}
	/*	check right */
	if (m > 0 && game.p[m-1][n] == color && ma[m-1][n] == EMPTY) {
		cnt += count_string1(m-1,n,color) ;
	}
	/*	check bottom */
	if (n < game.BoardSize-1 && game.p[m][n + 1] ==color && ma[m][n + 1] == EMPTY) {
		cnt += count_string1(m,n+1,color) ;
	}
	/*	check top */
	if (n > 0 && game.p[m][n-1] ==color && ma[m][n-1] == EMPTY) {
		cnt += count_string1(m,n-1,color) ;
	}
	return cnt;
}

/******************************************************/
static void	count_string2(int m, int n,int color ,int ng0)
/*	write string number to ng for debugging	*/
{

	game.ng[m][n] = ng0;
	ma[m][n] = color;

	/*printf("%i %c : game.ng:%i\n",game.BoardSize - m,'A'+n,ng0);*/
	/*	check left */
	if (m < game.BoardSize-1 && game.p[m+1][n] ==color && game.ng[m+1][n] < ng0) {
		count_string2(m+1,n,color,ng0);
	}
	/*	check right */
	if (m > 0 && game.p[m-1][n] ==color && game.ng[m-1][n] < ng0) {
		count_string2(m-1,n,color,ng0);
	}
	/*	check bottom */
	if (n < game.BoardSize-1 && game.p[m][n + 1] ==color && game.ng[m][n+1] < ng0) {
		count_string2(m,n+1,color,ng0);
	}
	/*	check top */
	if (n > 0 && game.p[m][n-1] ==color && game.ng[m][n-1] < ng0) {
		count_string2(m,n-1,color,ng0);
	}


}

int flagedge = 0;

/******************************************************/
int check_eye_sub1( int m, int n, int color)
{
	/*	check edge ? (hasikko ?) 	*/
	if (m < 0 || m>= game.BoardSize || n < 0 || n >= game.BoardSize) {
		flagedge = 1;
		return 1;
	}

	/*	Hum... not edge. Then is the color my color ? */
	if (game.p[m][n] == color ) return 1; /* yes */

	if (game.p[m][n] != EMPTY) return -1; /* color of enemy	*/
	return 0;

}

int	check_eye(int m,int n,int color)
/*
	not eye or may not be eye	: return 0
	1 eye		: return 1
	2 eyes	: return 2
*/
{
	int	tmp,pl,pr,pt,pb;
	int cnt;
	int m1,n1;

	flagedge = 0;

	/*	1st step  1 eye	*/
	/*	horizontal & vertical 	*/
	tmp = (pl =check_eye_sub1(m-1,n,color)) +
		(pr = check_eye_sub1(m+1,n,color)) +
		(pb = check_eye_sub1(m,n-1,color)) +
		(pt = check_eye_sub1(m,n+1,color)) ;

	if (tmp < 3 ) return 0; /* more than 2 are empty or more than 1 is enemy */


	if (tmp == 4) {
		/*	may be one eye	*/
		cnt = 0;
		if (check_eye_sub1(m-1,n-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m-1,n+1,color) < 0 ) cnt++;
		if (check_eye_sub1(m+1,n-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m+1,n+1,color) < 0 ) cnt++;
		if (cnt + flagedge >= 2) return 0; /* must be threatened */
		return 1; /* may be one eye */
	}

	/*return 0;*//* checking two eye is not implemented */

	/* check two eyes */
	/* which direction ? */
	if (pl == 0) { /* left */
		m1 = m-1;
		n1 = n;
		if (check_eye_sub1(m1-1,n1,color)
		    + check_eye_sub1(m1,n1-1,color)
		    + check_eye_sub1(m1,n1+1,color) <3)
			return 0;

		cnt = 0;
		if (check_eye_sub1(m1-1,n-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m1-1,n+1,color) < 0 ) cnt++;
		if (check_eye_sub1(m+1,n-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m+1,n+1,color) < 0 ) cnt++;
		if (cnt + flagedge >= 2) return 0; /* must be two eyes */
		return 1;
	}
	if (pr == 0) { /* right */
		m1 = m+1;
		n1 = n;
		if (check_eye_sub1(m1+1,n1,color)
		    + check_eye_sub1(m1,n1-1,color)
		    + check_eye_sub1(m1,n1+1,color) <3)
			return 0;

		cnt = 0;
		if (check_eye_sub1(m-1,n-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m-1,n+1,color) < 0 ) cnt++;
		if (check_eye_sub1(m1+1,n-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m1+1,n+1,color) < 0 ) cnt++;
		if (cnt + flagedge >= 2) return 0; /* must be two eyes */
		return 1;
	}
	if (pb == 0) { /* bottom */
		m1 = m;
		n1 = n-1;
		if (check_eye_sub1(m1,n1-1,color)
		    + check_eye_sub1(m1+1,n1,color)
		    + check_eye_sub1(m1-1,n1,color) <3)
			return 0;

		cnt = 0;
		if (check_eye_sub1(m-1,n1-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m-1,n+1,color) < 0 ) cnt++;
		if (check_eye_sub1(m+1,n1-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m+1,n+1,color) < 0 ) cnt++;
		if (cnt + flagedge >= 2) return 0; /* must be two eyes */
		return 1;
	}
	if (pt == 0) { /* top */
		m1 = m;
		n1 = n+1;
		if (check_eye_sub1(m1,n1+1,color)
		    + check_eye_sub1(m1+1,n1,color)
		    + check_eye_sub1(m1-1,n1,color) <3)
			return 0;

		cnt = 0;
		if (check_eye_sub1(m-1,n-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m-1,n1+1,color) < 0 ) cnt++;
		if (check_eye_sub1(m+1,n-1,color) < 0 ) cnt++;
		if (check_eye_sub1(m+1,n1+1,color) < 0 ) cnt++;
		if (cnt + flagedge >= 2) return 0; /* must be two eyes */
		return 1;
	}

	return 0 ;
}


