/*  OC_Piece_Sets.h -- OpenChess header for Piece Sets 
 *
 *  OpenChess version 2.0, is a CHESS game for Palm Pilot, adapted
 *  from GNU Chess 2, for Unix/DOS environments
 *  Copyright (C) 1986, 1987, 1988 Free Software Foundation, Inc.
 *  Copyright (C) 2002, Son Altesse.
 *  Copyright (C) 2005, Olaf Richter.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#define RES_PIECE_SET_BASE_ID  4000
 
#define BMP_PIECES   RES_PIECE_SET_BASE_ID 
 
#define BMP_MASK     5
#define BMP_D160     0
#define BMP_D320     1
#define BMP_D240     2
#define BMP_M160     (BMP_D160+BMP_MASK)
#define BMP_M320     (BMP_D320+BMP_MASK)
#define BMP_M240     (BMP_D240+BMP_MASK)
#define BMP_DCNT     10

#define BMP_PAWN     0
#define BMP_KNIGHT   1
#define BMP_BISHOP   2
#define BMP_ROOK     3
#define BMP_QUEEN    4
#define BMP_KING     5
#define BMP_PCNT     6

#define BMP_LIGHT    0
#define BMP_DARK     1

#define BMP_LIGHT_SQUARE (RES_PIECE_SET_BASE_ID+900)
#define BMP_DARK_SQUARE  (RES_PIECE_SET_BASE_ID+910)

#define BLST_SQUARE_COLOR (RES_PIECE_SET_BASE_ID)
#define BLST_SQUARE_GRAY  (RES_PIECE_SET_BASE_ID+1)
