/***************************************************************************

Palm Chess Client
Copyright (C) 1999 David Barr (davidbarr@iname.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

****************************************************************************/

/*
 * This is based on code from Palm Ping, (c)1998 Machina Software Inc.
 */

#ifndef TCP_H
#define TCP_H

/* #include <sys/socket.h> */
#include <System/Unix/sys_socket.h>

#define MAXTIMEOUT      (10 * sysTicksPerSecond)
#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN	64
#endif

// externs
extern Word AppNetRefnum;
extern long AppNetTimeout;
extern Err errno;
extern Err error;
extern char HostName[];
extern char IPAddress[];
extern NetHostInfoPtr HostInfoPtr;
extern NetHostInfoBufType HostInfoBuffer;
//extern NetSocketRef SocketNumber;
extern NetSocketAddrINType Destination;
extern Word Port;
extern NetIPAddr DestinationIPAddress;
extern NetServInfoBufType ServInfoBuffer;
extern unsigned char ReceiveBuffer[];
extern NetSocketAddrType Sender;
extern Word SenderLength;
extern DWord SavedNetSettings;
extern NetMasterPBType Stats;


// prototypes
int CheckForNetwork( void );
Word GetHost( CharPtr lookup );
Word Connect( CharPtr name, CharPtr service, CharPtr protocol );
void Disconnect( NetSocketRef SocketNumber );
Err SendData( NetSocketRef SocketNumber, VoidPtr data, Word length );
Err ReceiveData( NetSocketRef SocketNumber );
CharPtr ConvertAddressToString( CharPtr string, NetIPAddr address );

#endif // TCP_H

// eof

