/*
Dotty V1.0 - The Dots Game (Les Petits Carreaux)
Copyright (C) 1998 Franois Pessaux (francois.pessaux@inria.fr)


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "pilrc.h"
#include "dots.h"
#include "protos.h"


void EventLoop (void)
{
  EventType event ;
  FormPtr form ;
  short error ;

  do {
    EvtGetEvent (&event, -1) ;
    if (SysHandleEvent (&event)) continue ;
    if (MenuHandleEvent ((void *)0, &event, &error)) continue ;

    if (event.eType == frmLoadEvent)
      {
	int formID ;

	formID = event.data.frmLoad.formID ;
	form = FrmInitForm (formID) ;
	FrmSetActiveForm (form) ;
	switch (formID) 
	  {
	  case gameForm:
	    FrmSetEventHandler (form, (FormEventHandlerPtr) GameEventHandler) ;
	    break ;

	  case optionForm:
	    FrmSetEventHandler (form,
				(FormEventHandlerPtr) OptionEventHandler) ;
	    break ;
	  }
      }
    FrmDispatchEvent (&event) ;
  } while (event.eType != appStopEvent) ;

  EndApplication () ;
}





DWord  PilotMain (Word cmd, Ptr cmdPBP, Word launchFlags)
{
  if (cmd == sysAppLaunchCmdNormalLaunch)
    {
      /* Initialize internal game data */
      InitApplication () ;

      FrmGotoForm (gameForm) ;
      EventLoop () ;

    }
  return (0) ;
}
