/*
Dotty V1.0 - The Dots Game (Les Petits Carreaux)
Copyright (C) 1998 Franois Pessaux (francois.pessaux@inria.fr)


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/


#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "pilrc.h"
#include "bool.h"
#include "dots.h"
#include "protos.h"

extern unsigned char remaining_cells ;
extern boolean human_turn ;


void DisplayIntro (void)
{
  /* Clear game zone of the screen */
  { RectangleType rect = { 0, TITLE_HEIGHT, 160, 160 - TITLE_HEIGHT } ;
  WinEraseRectangle (&rect, 0) ;
  /* Clear score zone */
  rect.topLeft.x = 80 ; rect.topLeft.y = 1 ;
  rect.extent.x = 80 ; rect.extent.y = 12 ;
  WinEraseRectangle (&rect, 0) ; }

  FntSetFont (2) ;
  WinDrawChars ("The Dots Game", 13, 35, 35) ;
  WinDrawChars ("(Les Petits Carreaux)", 21, 20, 50) ;
  FntSetFont (0) ;
  WinDrawChars ("Written by", 10, 55, 70) ;
  WinDrawChars ("Franois Pessaux", 16, 42, 90) ;
  WinDrawChars ("V 1.0", 5, 65, 110) ;
  WinDrawChars ("Use menu to start", 17, 40, 145) ;
}




Boolean GameEventHandler (EventPtr event)
{
  switch (event->eType) 
    {
    case frmOpenEvent:
      FrmDrawForm (FrmGetActiveForm ()) ;
      /* Check if a saved game is now running */
      if (remaining_cells > 0) {
	init_game_display () ;
	refresh_whole_game_display () ;
	/* A game was loaded. Let's Pilot play if it's its turn  */
	if (! human_turn) send_computer_play_event () ;
      }
      else {
	DisplayIntro () ;
      }
      return (TRUE) ;
      break ;

    case penDownEvent:
      /* Human player can act if it's his turn and the game is not over */
      if ((human_turn) && (remaining_cells > 0)) {
	handle_human_play (event->screenX, event->screenY) ;
      }
      return (TRUE) ;
      break ;

    case dotComputerMustPlay:
      /* Computer must play */
      if (remaining_cells > 0) handle_computer_think () ;
      return (TRUE) ;
      break ;

    case menuEvent:
      switch (event->data.menu.itemID)
	{
	case menuitemNew:
	  clear_game () ;
	  init_game_display () ;
	  return (TRUE) ;
	  break ;

	case menuitemRule:
	  FrmCustomAlert (standardInfoAlert,
			  "Conquier cells by marking edges.",
			  "You get a cell when you close it.",
			  "When you get one, you can play again") ;
	  break ;

	case menuitemOptions:
	  FrmPopupForm (optionForm) ;
	  return (TRUE) ;
	  break ;

	case menuitemAbout:
	  FrmCustomAlert (standardInfoAlert,
			  "Dotty V1.0 1998",
			  "\251 Francois PESSAUX",
			  "Freeware of course !") ;
	  return (TRUE) ;
	  break ;
	}
      break ;
    }

  return (FALSE) ;
}
