/*
Dotty V1.0 - The Dots Game (Les Petits Carreaux)
Copyright (C) 1998 Franois Pessaux (francois.pessaux@inria.fr)


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>

#include "bool.h"
#include "dots.h"
#include "protos.h"


extern struct edge *edges ;


unsigned char cell_weight (struct cell *cell)
{
  unsigned char w = 0 ;

 if (edges[cell->left].drawn) w++ ;
 if (edges[cell->top].drawn) w++ ;
 if (edges[cell->right].drawn) w++ ;
 if (edges[cell->bottom].drawn) w++ ;

 return (w) ;
}




/* Returns the NUMBER of the edge, hence it's possible to find it */
/* and to draw it on the screen */
unsigned char cell_open_side (struct cell *cell)
{
 if (! edges[cell->left].drawn) return (cell->left) ;
 if (! edges[cell->top].drawn) return (cell->top) ;
 if (! edges[cell->right].drawn) return (cell->right) ;
 if (! edges[cell->bottom].drawn) return (cell->bottom) ;
 /* We should never arrive here */
}
