
#ifndef h_stdfile_h
#define h_stdfile_h

/* define if you want a alert to show each function as entered
 */
//#define DEBUGFILE 1

/* simulate stdio FILE using VFS; why not?
 */
typedef struct {
  char filename [ 34 ]; // for fun
  UInt32 size; // get file size (for read types)
  FileRef ref;
  UInt8 bufferp; // 1 for buffered input, 2 for output, 0 no buffering
  char buffer [ 255 ];
  UInt8 tail;
} FILE;
//#define FILE FileRef

#define stderr ((FILE*) 37)
#define stdin ((FILE*) 36)
#define stdout ((FILE*) 35)

#define SEEK_SET vfsOriginBeginning
#define SEEK_CUR vfsOriginCurrent
#define SEEK_END vfsOriginEnd

FILE *fopen ( signed char *filename, char *mode );
Int8 fclose ( FILE *file );
Int8 fseek ( FILE *file, UInt32 rel, UInt16 source );
UInt32 fread ( char *buf, UInt32 size, UInt32 num, FILE *file );
UInt32 fwrite ( char *buf, UInt32 size, UInt32 num, FILE *file );
int fgetc ( FILE *file );
int fputs ( const char *str, FILE *stream );
int fputc ( UInt8 c, FILE *file );
UInt32 ftell ( FILE *file );
int fprintf ( FILE *file, char *fmt, ... );
#define ferror(f) 0
#define feof(x) 0
long int fscanf_get_d ( FILE *f );
char fscanf_get_c ( FILE *f );

/* special extensions
 */
#define STDTEMPFILE "KronosTemp"

MemHandle pdb_temp_open ( char *filename ); // copy to RAM and open
void pdb_temp_close ( char *filename );     // back to VFS and delete temp

UInt8 file_exists ( char *filename );
UInt8 file_delete ( char *filename );

#endif
