
#ifndef h_kronos_h
#define h_kronos_h

/* DEDICATION
 * This code is for Swampie, may he rest in pieace :( When it thunders outside,
 * maybe its old Stevie on the big Harley in the sky.
 */

/*
 * KRONOS
 * A IF-engine encapsulation and interface for Palm OS. Or something.
 * Jeff Mitchell, Codejedi, 2003.
 *
 * Kronos is a "adapter" for Palm OS; it includes a user interface and
 * all the Palm OS centric stuff needed to handle an IF game. It also includes
 * wrappers for Standard C libs and other things not normally available to
 * Palm OS, to make porting IF engines seamless and painless.
 *
 * The goals of the project:
 * 1) To port many IF engines to Palm OS under one consistent hood. A good
 *    user experience.
 * 2) To make the porting process easy; we do not wish to break away from the
 *    source projects.. Kronos will use Magnetic 2.2 or later; it should be
 *    trivial to upgrade to a new Magnetic should one ever come along. As such
 *    we must minimize code changes to the foreign codebases.
 * 3) Reusability; since Palm OS lacks a Standard C library (in name; most
 *    functions are available under different names with different
 *    requirements), then it is hoped that Kronos's file I/O and perhaps
 *    other routines will be of use for things like a Nethack project or
 *    other cool simple POSIX apps.
 * 4) Most importantly.. I want to beat The Pawn, since it drove me mad
 *    a long time ago. I've been using Magnetic on and off (see my other
 *    ports of it) for a long time.. but only my PDA is at my side. Well,
 *    my PDA and my wife but she makes a bad interpreter :)
 */

#define VERSION "1.4.1"
#define CREATORID 'Magn'

/* LICENSING
 * Kronos itself (formerly Magnetic/Palm) is GPL.
 * Do not remove the source history or the GPL license.. that would be a
 * violation of the GPL. But do use enjoy Kronos and if it helps you
 * in your own projects be shedding light on the horrors of Palm OS
 * high res or filesystem code, then I am honoured to be at your service.
 *
 * WARRATY
 * No warranty is implied. Enjoy at your own risk.
 *
 * CREDITS
 * The application includes credits; Kronos would not be useful were it not
 * for the many authors of Frotz, ScottFree, Magnetic, and indeed for
 * Infocom, Magnetic Scrolls, Adventure International, Graham Nelson and
 * many many others.
 * 
 * My wife is my soul.
 */

/* USAGE:
 *
 * See the README.txt included in the source directory.
 *
 * 1) Foreign modules generally need only include a few header files to get
 * going; you'll need to comment or #if out existing head includes since
 * Palm OS lacks things like stdio.h; but #include kronos.h and adapter.h
 * and they shoudl be buildable, with luck.
 *
 * 2) You likely need to twiddle the display code; ie: They often use
 * printf() or fputc() or the like; fine. But for Kronos to actually render
 * anything, use ms_flush() to update the display.
 *
 */

/* COMPILE NOTES
 * At first I wanted to make delcarations for everything, since projects like
 * Magnetic miss a lot of them. Then I got sick of it, and didn't want to muck
 * in the foreign codebases (see rational above); as such, I have set
 * CodeWarrior to not require declarations. Furthermore, due to the way
 * some of the foreign codebases do their thing, I have had to turn off
 * strict pointer typing, too. A drag, but such is life. Be careful.
 *
 * Kronos is built with CodeWarrior 9, though it shoudl easily backport to
 * older versions or to gcc; I used CW as time was of the essence and I wanted
 * to use Constructor nicely.
 *
 * The ARMlet code is all built using gcc, cross compiled for ARM. You can
 * use the ARMlet-dr2 build from Palm, or make your own. I use my own, but the
 * linker script from Palm. It is all provided.
 */

/*
 * conveniance defines
 */

#define VFSROOT        "/Palm/Programs/"
#define VFSPATH        "/Palm/Programs/Kronos/"

#define NOTEFILE       "notes.txt" /* notes for game, in save dir */
#define MAPFILE        "map.txt"   /* for map storage */
#define AUTOSAVEFILE   "autosave.sav"

#define THUMB_X        115
#define THUMB_Y        131

/*
 * conveniance includes
 */

#include "stdfile.h"
#include "adapter.h"
#include "curses.h"

/* emu kickers
 */
int emu_main ( int argc, char **argv );
void keyboard_push ( char *text );
UInt8 is_magnetic ( char *filename );
UInt8 is_scottfree ( char *filename );
UInt8 is_zcode ( char *filename );

/* emu assist
 */
UInt8 force_auto_save ( void );
UInt8 force_auto_load ( void );
void kronos_reset ( void );

/* word lists
 */
extern char *relative_word_list[];
extern char *standalone_word_list[];
extern char *navigation_word_list[];

/* assumes List box is in the right location and sized; this function will
 * push the correct words into the display field or keyboard buffer as
 * appropriate
 */
void words_translate ( char *tapword, char *from, char *r_to );
void words_popword ( char *words[], ListPtr *list, char *tapword );
void WordsDrawList ( Int16 itemNum, RectangleType *bounds, Char **itemsText );

#endif
